/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.json.JSONVisitor;
import org.apache.tamaya.spi.PropertySource;

public class JSONPropertySource
implements PropertySource {
    private URL urlResource;
    private Map<String, String> values;
    private int ordinal;

    public JSONPropertySource(URL resource) {
        this(resource, 0);
    }

    public JSONPropertySource(URL resource, int defaultOrdinal) {
        this.urlResource = Objects.requireNonNull(resource);
        this.ordinal = defaultOrdinal;
        this.values = this.readConfig(this.urlResource);
        if (this.values.containsKey("tamaya.ordinal")) {
            this.ordinal = Integer.parseInt(this.values.get("tamaya.ordinal"));
        }
    }

    public int getOrdinal() {
        String configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.ordinal;
    }

    public String getName() {
        return this.urlResource.toExternalForm();
    }

    public String get(String key) {
        return this.getProperties().get(key);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.values);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, String> readConfig(URL urlResource) {
        try (InputStream is = urlResource.openStream();){
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(is);
            if (!(root instanceof ObjectNode)) {
                throw new ConfigException("Currently only JSON objects are supported");
            }
            HashMap<String, String> values = new HashMap<String, String>();
            JSONVisitor visitor = new JSONVisitor((ObjectNode)root, values);
            visitor.run();
            HashMap<String, String> hashMap = values;
            return hashMap;
        }
        catch (Throwable t) {
            throw new ConfigException(String.format("Failed to read properties from %s", urlResource.toExternalForm()), t);
        }
    }

    public boolean isScannable() {
        return true;
    }
}

