/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Objects;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationDataBuilder;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.json.JSONVisitor;

public class JSONFormat
implements ConfigurationFormat {
    public String getName() {
        return "json";
    }

    public boolean accepts(URL url) {
        return Objects.requireNonNull(url).getPath().endsWith(".json");
    }

    public ConfigurationData readConfiguration(String resource, InputStream inputStream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(inputStream);
            HashMap<String, String> values = new HashMap<String, String>();
            JSONVisitor visitor = new JSONVisitor((ObjectNode)root, values);
            visitor.run();
            return ConfigurationDataBuilder.of((String)resource, (ConfigurationFormat)this).addProperties(values).build();
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read data from " + resource);
        }
    }
}

