/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.Experimental;
import org.apache.tamaya.spi.PropertyValue;

public class FilterContext {
    private final PropertyValue value;
    private final ConfigurationContext context;
    @Experimental
    private Map<String, PropertyValue> configEntries = new HashMap<String, PropertyValue>();
    @Experimental
    private boolean singlePropertyScoped;

    public FilterContext(PropertyValue value, Map<String, PropertyValue> configEntries, ConfigurationContext context) {
        Objects.requireNonNull(value, "Value must not be null.");
        Objects.requireNonNull(configEntries, "Initial configuration entries must be not null.");
        Objects.requireNonNull(context, "Context must be not null.");
        this.singlePropertyScoped = false;
        this.value = Objects.requireNonNull(value);
        this.context = Objects.requireNonNull(context);
        this.configEntries.putAll(configEntries);
        this.configEntries = Collections.unmodifiableMap(this.configEntries);
    }

    public FilterContext(PropertyValue value, ConfigurationContext context) {
        Objects.requireNonNull(value, "Value must not be null.");
        Objects.requireNonNull(context, "Context must be not null.");
        this.singlePropertyScoped = true;
        this.context = Objects.requireNonNull(context);
        this.value = Objects.requireNonNull(value);
        this.configEntries = Collections.unmodifiableMap(this.configEntries);
    }

    public ConfigurationContext getContext() {
        return this.context;
    }

    public PropertyValue getProperty() {
        return this.value;
    }

    @Experimental
    public boolean isSinglePropertyScoped() {
        return this.singlePropertyScoped;
    }

    @Experimental
    public Map<String, PropertyValue> getConfigEntries() {
        return this.configEntries;
    }

    public String toString() {
        return "FilterContext{value='" + this.value + "', configEntries=" + this.configEntries.keySet() + '}';
    }
}

