/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.BasePropertySource;

public class SystemPropertySource
extends BasePropertySource {
    public static final int DEFAULT_ORDINAL = 1000;
    private volatile Map<String, PropertyValue> cachedProperties;
    private volatile int previousHash;
    private String prefix;
    private boolean disabled = false;

    public SystemPropertySource() {
        super("system-properties", 1000);
        this.initFromSystemProperties();
        if (!this.disabled) {
            this.cachedProperties = Collections.unmodifiableMap(this.loadProperties());
        }
    }

    private void initFromSystemProperties() {
        String value = System.getProperty("tamaya.sysprops.prefix");
        if (value == null) {
            this.prefix = System.getenv("tamaya.sysprops.prefix");
        }
        if ((value = System.getProperty("tamaya.sysprops.disable")) == null) {
            value = System.getenv("tamaya.sysprops.disable");
        }
        if (value == null) {
            value = System.getProperty("tamaya.defaults.disable");
        }
        if (value == null) {
            value = System.getenv("tamaya.defaults.disable");
        }
        if (value != null && !value.isEmpty()) {
            this.disabled = Boolean.parseBoolean(value);
        }
    }

    public SystemPropertySource(int ordinal) {
        this(null, ordinal);
    }

    public SystemPropertySource(String prefix, int ordinal) {
        this.prefix = prefix;
        this.setOrdinal(ordinal);
    }

    public SystemPropertySource(String prefix) {
        this.prefix = prefix;
    }

    private Map<String, PropertyValue> loadProperties() {
        Properties sysProps = System.getProperties();
        this.previousHash = System.getProperties().hashCode();
        String prefix = this.prefix;
        HashMap<String, PropertyValue> entries = new HashMap<String, PropertyValue>();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            if (prefix == null) {
                entries.put((String)entry.getKey(), PropertyValue.of((String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)this.getName()));
                continue;
            }
            entries.put(prefix + entry.getKey(), PropertyValue.of((String)(prefix + entry.getKey()), (String)((String)entry.getValue()), (String)this.getName()));
        }
        return entries;
    }

    @Override
    public String getName() {
        if (this.disabled) {
            return super.getName() + "(disabled)";
        }
        return super.getName();
    }

    @Override
    public PropertyValue get(String key) {
        if (this.disabled) {
            return null;
        }
        String prefix = this.prefix;
        if (prefix == null) {
            return PropertyValue.of((String)key, (String)System.getProperty(key), (String)this.getName());
        }
        return PropertyValue.of((String)key, (String)System.getProperty(key.substring(prefix.length())), (String)this.getName());
    }

    public Map<String, PropertyValue> getProperties() {
        if (this.disabled) {
            return Collections.emptyMap();
        }
        if (this.previousHash != System.getProperties().hashCode()) {
            Map<String, PropertyValue> properties = this.loadProperties();
            this.cachedProperties = Collections.unmodifiableMap(properties);
        }
        return this.cachedProperties;
    }

    @Override
    public boolean isScannable() {
        return true;
    }

    @Override
    protected String toStringValues() {
        return super.toStringValues() + "  prefix=" + this.prefix + '\n' + "  disabled=" + this.disabled + '\n';
    }
}

