/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.BasePropertySource;

public class SimplePropertySource
extends BasePropertySource {
    private static final Logger LOG = Logger.getLogger(SimplePropertySource.class.getName());
    private Map<String, PropertyValue> properties = new HashMap<String, PropertyValue>();

    public SimplePropertySource(File propertiesLocation) {
        super(propertiesLocation.toString(), 0);
        try {
            this.properties = SimplePropertySource.load(propertiesLocation.toURI().toURL());
        }
        catch (IOException e) {
            throw new ConfigException("Failed to load properties from " + propertiesLocation, (Throwable)e);
        }
    }

    public SimplePropertySource(URL propertiesLocation) {
        super(propertiesLocation.toString(), 0);
        this.properties = SimplePropertySource.load(Objects.requireNonNull(propertiesLocation));
    }

    public SimplePropertySource(String name, Map<String, String> properties, int defaultOrdinal) {
        super(name, defaultOrdinal);
        for (Map.Entry<String, String> en : properties.entrySet()) {
            this.properties.put(en.getKey(), PropertyValue.of((String)en.getKey(), (String)en.getValue(), (String)name));
        }
    }

    public SimplePropertySource(String name, Map<String, String> properties) {
        this(name, properties, 0);
    }

    public SimplePropertySource(String name, URL propertiesLocation) {
        super(name, 0);
        this.properties = SimplePropertySource.load(propertiesLocation);
    }

    private SimplePropertySource(Builder builder) {
        this.properties = builder.properties;
        if (builder.defaultOrdinal != null) {
            this.setDefaultOrdinal(builder.defaultOrdinal);
        }
        if (builder.ordinal != null) {
            this.setOrdinal(builder.ordinal);
        }
        this.setName(builder.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, PropertyValue> getProperties() {
        return this.properties;
    }

    private static Map<String, PropertyValue> load(URL propertiesFile) {
        boolean isXML = SimplePropertySource.isXMLPropertieFiles(propertiesFile);
        HashMap<String, PropertyValue> properties = new HashMap<String, PropertyValue>();
        try (InputStream stream = propertiesFile.openStream();){
            Properties props = new Properties();
            if (stream != null) {
                if (isXML) {
                    props.loadFromXML(stream);
                } else {
                    props.load(stream);
                }
            }
            String source = propertiesFile.toString();
            for (String key : props.stringPropertyNames()) {
                properties.put(key, PropertyValue.of((String)key, (String)props.getProperty(key), (String)source));
            }
        }
        catch (IOException e) {
            throw new ConfigException("Error loading properties from " + propertiesFile, (Throwable)e);
        }
        return properties;
    }

    private static boolean isXMLPropertieFiles(URL url) {
        return url.getFile().endsWith(".xml");
    }

    public static final class Builder {
        private String name;
        private Integer defaultOrdinal;
        private Integer ordinal;
        private Map<String, PropertyValue> properties = new HashMap<String, PropertyValue>();

        private Builder() {
        }

        public Builder withUuidName() {
            this.name = UUID.randomUUID().toString();
            return this;
        }

        public Builder withName(String val) {
            this.name = Objects.requireNonNull(this.name);
            return this;
        }

        public Builder withOrdinal(int val) {
            this.ordinal = val;
            return this;
        }

        public Builder withDefaultOrdinal(int val) {
            this.defaultOrdinal = val;
            return this;
        }

        public Builder withProperties(URL resource) {
            this.properties.putAll(SimplePropertySource.load(resource));
            return this;
        }

        public Builder withProperties(File file) {
            try {
                this.properties.putAll(SimplePropertySource.load(file.toURI().toURL()));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to read file: " + file, e);
            }
            return this;
        }

        public Builder withProperties(Map<String, String> val) {
            for (Map.Entry<String, String> en : val.entrySet()) {
                this.properties.put(en.getKey(), PropertyValue.of((String)en.getKey(), (String)en.getValue(), (String)this.name));
            }
            return this;
        }

        public Builder withProperty(String key, String val) {
            this.properties.put(key, PropertyValue.of((String)key, (String)val, (String)this.name));
            return this;
        }

        public SimplePropertySource build() {
            return new SimplePropertySource(this);
        }
    }
}

