/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.Arrays;
import java.util.List;
import org.apache.tamaya.spi.FilterContext;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertyValue;

public final class RegexPropertyFilter
implements PropertyFilter {
    private List<String> includes;
    private List<String> excludes;

    public void setIncludes(String ... expressions) {
        this.includes = Arrays.asList(expressions);
    }

    public void setExcludes(String ... expressions) {
        this.excludes = Arrays.asList(expressions);
    }

    public PropertyValue filterProperty(PropertyValue valueToBeFiltered, FilterContext context) {
        if (this.includes != null) {
            for (String expression : this.includes) {
                if (!context.getProperty().getKey().matches(expression)) continue;
                return valueToBeFiltered;
            }
            return null;
        }
        if (this.excludes != null) {
            for (String expression : this.excludes) {
                if (!context.getProperty().getKey().matches(expression)) continue;
                return null;
            }
        }
        return valueToBeFiltered;
    }

    public String toString() {
        return "RegexPropertyFilter{includes='" + this.includes + '\'' + "excludes='" + this.excludes + '\'' + '}';
    }
}

