/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.FilterContext;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertyValue;

public final class PropertyFiltering {
    private static final Logger LOG = Logger.getLogger(PropertyFiltering.class.getName());
    private static final int MAX_FILTER_LOOPS = 10;

    private PropertyFiltering() {
    }

    public static PropertyValue applyFilter(PropertyValue value, ConfigurationContext context) {
        FilterContext filterContext = new FilterContext(value, context);
        return PropertyFiltering.filterValue(filterContext);
    }

    public static Map<String, PropertyValue> applyFilters(Map<String, PropertyValue> rawProperties, ConfigurationContext context) {
        HashMap<String, PropertyValue> result = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, PropertyValue> entry : rawProperties.entrySet()) {
            FilterContext filterContext = new FilterContext(entry.getValue(), rawProperties, context);
            PropertyValue filtered = PropertyFiltering.filterValue(filterContext);
            if (filtered == null) continue;
            result.put(filtered.getKey(), filtered);
        }
        return result;
    }

    private static PropertyValue filterValue(FilterContext context) {
        PropertyValue inputValue;
        PropertyValue filteredValue = inputValue = context.getProperty();
        for (int i = 0; i < 10; ++i) {
            int changes = 0;
            for (PropertyFilter filter : context.getContext().getPropertyFilters()) {
                filteredValue = filter.filterProperty(inputValue, context);
                if (filteredValue != null && !filteredValue.equals((Object)inputValue)) {
                    ++changes;
                    LOG.finest("Filter - " + inputValue + " -> " + filteredValue + " by " + filter);
                }
                if (filteredValue == null) {
                    LOG.finest("Filter removed entry - " + inputValue + ": " + filter);
                    break;
                }
                inputValue = filteredValue;
            }
            if (changes == 0) {
                LOG.finest("Finishing filter loop, no changes detected.");
                break;
            }
            if (filteredValue == null) break;
            if (i == 9) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Maximal filter loop count reached, aborting filter evaluation after cycles: " + i);
                continue;
            }
            LOG.finest("Repeating filter loop, changes detected: " + changes);
        }
        return filteredValue;
    }
}

