/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ServiceContextManager;
import org.apache.tamaya.spisupport.MapPropertySource;

public class PropertiesResourcePropertySource
extends MapPropertySource {
    private static final Logger LOGGER = Logger.getLogger(PropertiesResourcePropertySource.class.getName());

    public PropertiesResourcePropertySource(URL url) {
        this(url, null);
    }

    public PropertiesResourcePropertySource(URL url, String prefix) {
        super(url.toExternalForm(), PropertiesResourcePropertySource.loadProps(url), prefix);
    }

    public PropertiesResourcePropertySource(String path, String prefix) {
        super(path, PropertiesResourcePropertySource.loadProps(path, null), prefix);
    }

    public PropertiesResourcePropertySource(String path, String prefix, ClassLoader cl) {
        super(path, PropertiesResourcePropertySource.loadProps(path, cl), prefix);
    }

    private static Map<String, String> loadProps(String path, ClassLoader cl) {
        if (cl == null) {
            cl = PropertiesResourcePropertySource.class.getClassLoader();
        }
        URL url = ServiceContextManager.getServiceContext().getResource(path, cl);
        return PropertiesResourcePropertySource.loadProps(url);
    }

    private static Map<String, String> loadProps(URL url) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (url != null) {
            try (InputStream is = url.openStream();){
                Properties props = new Properties();
                props.load(is);
                for (Map.Entry<Object, Object> en : props.entrySet()) {
                    result.put(en.getKey().toString(), en.getValue().toString());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to read properties from " + url, e);
            }
        } else {
            LOGGER.log(Level.WARNING, "No properties found at " + url);
        }
        return result;
    }
}

