/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.BasePropertySource;

public class MapPropertySource
extends BasePropertySource {
    private final Map<String, PropertyValue> props = new HashMap<String, PropertyValue>();

    public MapPropertySource(String name, Map<String, String> props) {
        this(name, props, null);
    }

    public MapPropertySource(String name, Map<String, String> props, String prefix) {
        super(name);
        if (prefix == null) {
            for (Map.Entry<String, String> en : props.entrySet()) {
                this.props.put(en.getKey(), PropertyValue.of((String)en.getKey(), (String)en.getValue(), (String)name));
            }
        } else {
            for (Map.Entry<String, String> en : props.entrySet()) {
                this.props.put(prefix + en.getKey(), PropertyValue.of((String)(prefix + en.getKey()), (String)en.getValue(), (String)name));
            }
        }
    }

    public MapPropertySource(String name, Properties props, String prefix) {
        this(name, MapPropertySource.getMap(props), prefix);
    }

    public static Map<String, String> getMap(Properties props) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> en : props.entrySet()) {
            result.put(en.getKey().toString(), en.getValue().toString());
        }
        return result;
    }

    public Map<String, PropertyValue> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }
}

