/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.BasePropertySource;

public class EnvironmentPropertySource
extends BasePropertySource {
    private static final Logger LOG = Logger.getLogger(EnvironmentPropertySource.class.getName());
    public static final int DEFAULT_ORDINAL = 300;
    private String prefix;
    private boolean disabled = false;

    public EnvironmentPropertySource() {
        this.initFromSystemProperties();
    }

    private void initFromSystemProperties() {
        String value = System.getProperty("tamaya.envprops.prefix");
        if (value == null) {
            this.prefix = System.getenv("tamaya.envprops.prefix");
        }
        if ((value = System.getProperty("tamaya.envprops.disable")) == null) {
            value = System.getenv("tamaya.envprops.disable");
        }
        if (value == null) {
            value = System.getProperty("tamaya.defaults.disable");
        }
        if (value == null) {
            value = System.getenv("tamaya.defaults.disable");
        }
        if (value != null && !value.isEmpty()) {
            this.disabled = Boolean.parseBoolean(value);
        }
    }

    public EnvironmentPropertySource(int ordinal) {
        this(null, ordinal);
    }

    public EnvironmentPropertySource(String prefix, int ordinal) {
        super("environment-properties");
        this.prefix = prefix;
        this.setOrdinal(ordinal);
    }

    public EnvironmentPropertySource(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public int getDefaultOrdinal() {
        return 300;
    }

    @Override
    public String getName() {
        if (this.disabled) {
            return super.getName() + "(disabled)";
        }
        return super.getName();
    }

    @Override
    public PropertyValue get(String key) {
        if (this.disabled) {
            return null;
        }
        String prefix = this.prefix;
        if (prefix == null) {
            return PropertyValue.of((String)key, (String)System.getenv(key), (String)this.getName());
        }
        return PropertyValue.of((String)key, (String)System.getenv(key.substring(prefix.length())), (String)this.getName());
    }

    public Map<String, PropertyValue> getProperties() {
        if (this.disabled) {
            return Collections.emptyMap();
        }
        String prefix = this.prefix;
        if (prefix == null) {
            HashMap<String, PropertyValue> entries = new HashMap<String, PropertyValue>(System.getenv().size());
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                entries.put(entry.getKey(), PropertyValue.of((String)entry.getKey(), (String)entry.getValue(), (String)this.getName()));
            }
            return entries;
        }
        HashMap<String, PropertyValue> entries = new HashMap<String, PropertyValue>(System.getenv().size());
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            entries.put(prefix + entry.getKey(), PropertyValue.of((String)(prefix + entry.getKey()), (String)entry.getValue(), (String)this.getName()));
        }
        return entries;
    }

    @Override
    public boolean isScannable() {
        return true;
    }

    @Override
    protected String toStringValues() {
        return super.toStringValues() + "  prefix=" + this.prefix + '\n' + "  disabled=" + this.disabled + '\n';
    }
}

