/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContextManager;
import org.apache.tamaya.spisupport.DefaultConfigurationContext;

public class DefaultConfigurationContextBuilder
implements ConfigurationContextBuilder {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationContextBuilder.class.getName());
    List<PropertyFilter> propertyFilters = new ArrayList<PropertyFilter>();
    List<PropertySource> propertySources = new ArrayList<PropertySource>();
    PropertyValueCombinationPolicy combinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
    Map<TypeLiteral<?>, Collection<PropertyConverter<?>>> propertyConverters = new HashMap();
    private boolean built;

    public DefaultConfigurationContextBuilder() {
    }

    public DefaultConfigurationContextBuilder(ConfigurationContext context) {
        this.propertyConverters.putAll(context.getPropertyConverters());
        this.propertyFilters.addAll(context.getPropertyFilters());
        for (PropertySource ps : context.getPropertySources()) {
            this.addPropertySources(ps);
        }
        this.combinationPolicy = context.getPropertyValueCombinationPolicy();
    }

    ConfigurationContextBuilder setConfigurationContext(ConfigurationContext configurationContext) {
        this.checkBuilderState();
        this.propertyFilters.clear();
        this.propertyFilters.addAll(configurationContext.getPropertyFilters());
        this.propertySources.clear();
        for (PropertySource ps : configurationContext.getPropertySources()) {
            this.addPropertySources(ps);
        }
        this.propertyConverters.clear();
        this.propertyConverters.putAll(configurationContext.getPropertyConverters());
        this.combinationPolicy = configurationContext.getPropertyValueCombinationPolicy();
        return this;
    }

    public ConfigurationContextBuilder setContext(ConfigurationContext context) {
        this.checkBuilderState();
        this.propertyConverters.putAll(context.getPropertyConverters());
        for (PropertySource ps : context.getPropertySources()) {
            this.propertySources.add(ps);
        }
        this.propertyFilters.addAll(context.getPropertyFilters());
        this.combinationPolicy = context.getPropertyValueCombinationPolicy();
        return this;
    }

    public ConfigurationContextBuilder addPropertySources(PropertySource ... sources) {
        return this.addPropertySources(Arrays.asList(sources));
    }

    public ConfigurationContextBuilder addPropertySources(Collection<PropertySource> sources) {
        this.checkBuilderState();
        for (PropertySource source : sources) {
            if (this.propertySources.contains(source)) continue;
            this.propertySources.add(source);
        }
        return this;
    }

    public DefaultConfigurationContextBuilder addDefaultPropertyFilters() {
        this.checkBuilderState();
        for (PropertyFilter pf : ServiceContextManager.getServiceContext().getServices(PropertyFilter.class)) {
            this.addPropertyFilters(pf);
        }
        return this;
    }

    public DefaultConfigurationContextBuilder addDefaultPropertySources() {
        this.checkBuilderState();
        for (PropertySource ps : ServiceContextManager.getServiceContext().getServices(PropertySource.class)) {
            this.addPropertySources(ps);
        }
        for (PropertySourceProvider pv : ServiceContextManager.getServiceContext().getServices(PropertySourceProvider.class)) {
            for (PropertySource ps : pv.getPropertySources()) {
                this.addPropertySources(ps);
            }
        }
        return this;
    }

    public DefaultConfigurationContextBuilder addDefaultPropertyConverters() {
        this.checkBuilderState();
        for (Map.Entry<TypeLiteral, Collection<PropertyConverter>> en : this.getDefaultPropertyConverters().entrySet()) {
            for (PropertyConverter pc : en.getValue()) {
                this.addPropertyConverters(en.getKey(), pc);
            }
        }
        return this;
    }

    public ConfigurationContextBuilder removePropertySources(PropertySource ... propertySources) {
        return this.removePropertySources(Arrays.asList(propertySources));
    }

    public ConfigurationContextBuilder removePropertySources(Collection<PropertySource> propertySources) {
        this.checkBuilderState();
        this.propertySources.removeAll(propertySources);
        return this;
    }

    private PropertySource getPropertySource(String name) {
        for (PropertySource ps : this.propertySources) {
            if (!ps.getName().equals(name)) continue;
            return ps;
        }
        throw new IllegalArgumentException("No such PropertySource: " + name);
    }

    public List<PropertySource> getPropertySources() {
        return this.propertySources;
    }

    public ConfigurationContextBuilder increasePriority(PropertySource propertySource) {
        this.checkBuilderState();
        int index = this.propertySources.indexOf(propertySource);
        if (index < 0) {
            throw new IllegalArgumentException("No such PropertySource: " + propertySource);
        }
        if (index < this.propertySources.size() - 1) {
            this.propertySources.remove(propertySource);
            this.propertySources.add(index + 1, propertySource);
        }
        return this;
    }

    public ConfigurationContextBuilder decreasePriority(PropertySource propertySource) {
        this.checkBuilderState();
        int index = this.propertySources.indexOf(propertySource);
        if (index < 0) {
            throw new IllegalArgumentException("No such PropertySource: " + propertySource);
        }
        if (index > 0) {
            this.propertySources.remove(propertySource);
            this.propertySources.add(index - 1, propertySource);
        }
        return this;
    }

    public ConfigurationContextBuilder highestPriority(PropertySource propertySource) {
        this.checkBuilderState();
        int index = this.propertySources.indexOf(propertySource);
        if (index < 0) {
            throw new IllegalArgumentException("No such PropertySource: " + propertySource);
        }
        if (index < this.propertySources.size() - 1) {
            this.propertySources.remove(propertySource);
            this.propertySources.add(propertySource);
        }
        return this;
    }

    public ConfigurationContextBuilder lowestPriority(PropertySource propertySource) {
        this.checkBuilderState();
        int index = this.propertySources.indexOf(propertySource);
        if (index < 0) {
            throw new IllegalArgumentException("No such PropertySource: " + propertySource);
        }
        if (index > 0) {
            this.propertySources.remove(propertySource);
            this.propertySources.add(0, propertySource);
        }
        return this;
    }

    public ConfigurationContextBuilder addPropertyFilters(PropertyFilter ... filters) {
        return this.addPropertyFilters(Arrays.asList(filters));
    }

    public ConfigurationContextBuilder addPropertyFilters(Collection<PropertyFilter> filters) {
        this.checkBuilderState();
        for (PropertyFilter f : filters) {
            if (this.propertyFilters.contains(f)) continue;
            this.propertyFilters.add(f);
        }
        return this;
    }

    public ConfigurationContextBuilder removePropertyFilters(PropertyFilter ... filters) {
        return this.removePropertyFilters(Arrays.asList(filters));
    }

    public ConfigurationContextBuilder removePropertyFilters(Collection<PropertyFilter> filters) {
        this.checkBuilderState();
        this.propertyFilters.removeAll(filters);
        return this;
    }

    public <T> ConfigurationContextBuilder removePropertyConverters(TypeLiteral<T> typeToConvert, PropertyConverter<T> ... converters) {
        return this.removePropertyConverters(typeToConvert, Arrays.asList(converters));
    }

    public <T> ConfigurationContextBuilder removePropertyConverters(TypeLiteral<T> typeToConvert, Collection<PropertyConverter<T>> converters) {
        Collection<PropertyConverter<PropertyConverter<T>>> subConverters = this.propertyConverters.get(typeToConvert);
        if (subConverters != null) {
            subConverters.removeAll(converters);
        }
        return this;
    }

    public ConfigurationContextBuilder removePropertyConverters(TypeLiteral<?> typeToConvert) {
        this.propertyConverters.remove(typeToConvert);
        return this;
    }

    public ConfigurationContextBuilder setPropertyValueCombinationPolicy(PropertyValueCombinationPolicy combinationPolicy) {
        this.checkBuilderState();
        this.combinationPolicy = Objects.requireNonNull(combinationPolicy);
        return this;
    }

    public <T> ConfigurationContextBuilder addPropertyConverters(TypeLiteral<T> type, PropertyConverter<T> ... propertyConverters) {
        this.checkBuilderState();
        Objects.requireNonNull(type);
        Objects.requireNonNull(propertyConverters);
        Collection<PropertyConverter<?>> converters = this.propertyConverters.get(type);
        if (converters == null) {
            converters = new ArrayList();
            this.propertyConverters.put(type, converters);
        }
        for (PropertyConverter<T> propertyConverter : propertyConverters) {
            if (!converters.contains(propertyConverter)) {
                converters.add(propertyConverter);
                continue;
            }
            LOG.warning("Converter ignored, already registered: " + propertyConverter);
        }
        return this;
    }

    public <T> ConfigurationContextBuilder addPropertyConverters(TypeLiteral<T> type, Collection<PropertyConverter<T>> propertyConverters) {
        this.checkBuilderState();
        Objects.requireNonNull(type);
        Objects.requireNonNull(propertyConverters);
        Collection<PropertyConverter<?>> converters = this.propertyConverters.get(type);
        if (converters == null) {
            converters = new ArrayList();
            this.propertyConverters.put(type, converters);
        }
        for (PropertyConverter<T> propertyConverter : propertyConverters) {
            if (!converters.contains(propertyConverter)) {
                converters.add(propertyConverter);
                continue;
            }
            LOG.warning("Converter ignored, already registered: " + propertyConverter);
        }
        return this;
    }

    protected ConfigurationContextBuilder loadDefaults() {
        this.checkBuilderState();
        this.combinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        this.addDefaultPropertySources();
        this.addDefaultPropertyFilters();
        this.addDefaultPropertyConverters();
        return this;
    }

    private Map<TypeLiteral, Collection<PropertyConverter>> getDefaultPropertyConverters() {
        HashMap<TypeLiteral, Collection<PropertyConverter>> result = new HashMap<TypeLiteral, Collection<PropertyConverter>>();
        for (PropertyConverter conv : ServiceContextManager.getServiceContext().getServices(PropertyConverter.class)) {
            TypeLiteral target = TypeLiteral.of((Type)TypeLiteral.of(conv.getClass()).getType());
            ArrayList<PropertyConverter> convList = (ArrayList<PropertyConverter>)result.get(target);
            if (convList == null) {
                convList = new ArrayList<PropertyConverter>();
                result.put(target, convList);
            }
            convList.add(conv);
        }
        return result;
    }

    public ConfigurationContext build() {
        this.checkBuilderState();
        this.built = true;
        return new DefaultConfigurationContext(this);
    }

    public ConfigurationContextBuilder sortPropertyFilter(Comparator<PropertyFilter> comparator) {
        Collections.sort(this.propertyFilters, comparator);
        return this;
    }

    public ConfigurationContextBuilder sortPropertySources(Comparator<PropertySource> comparator) {
        Collections.sort(this.propertySources, comparator);
        return this;
    }

    private void checkBuilderState() {
        if (this.built) {
            throw new IllegalStateException("Configuration has already been build.");
        }
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.propertyFilters;
    }

    public Map<TypeLiteral<?>, Collection<PropertyConverter<?>>> getPropertyConverter() {
        return Collections.unmodifiableMap(this.propertyConverters);
    }
}

