/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContextManager;
import org.apache.tamaya.spisupport.DefaultConfigurationContextBuilder;
import org.apache.tamaya.spisupport.PropertyConverterManager;
import org.apache.tamaya.spisupport.PropertySourceComparator;

public class DefaultConfigurationContext
implements ConfigurationContext {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationContext.class.getName());
    private final PropertyConverterManager propertyConverterManager = new PropertyConverterManager();
    private List<PropertySource> immutablePropertySources;
    private List<PropertyFilter> immutablePropertyFilters;
    private PropertyValueCombinationPolicy propertyValueCombinationPolicy;
    private final ReentrantReadWriteLock propertySourceLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock propertyFilterLock = new ReentrantReadWriteLock();

    protected DefaultConfigurationContext() {
        this(new DefaultConfigurationContextBuilder());
    }

    DefaultConfigurationContext(DefaultConfigurationContextBuilder builder) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        propertySources.addAll(builder.propertySources);
        this.immutablePropertySources = Collections.unmodifiableList(propertySources);
        LOG.info("Registered " + this.immutablePropertySources.size() + " property sources: " + this.immutablePropertySources);
        ArrayList<PropertyFilter> propertyFilters = new ArrayList<PropertyFilter>(builder.getPropertyFilters());
        this.immutablePropertyFilters = Collections.unmodifiableList(propertyFilters);
        LOG.info("Registered " + this.immutablePropertyFilters.size() + " property filters: " + this.immutablePropertyFilters);
        for (Map.Entry<TypeLiteral<?>, Collection<PropertyConverter<?>>> en : builder.getPropertyConverter().entrySet()) {
            for (PropertyConverter<?> converter : en.getValue()) {
                this.propertyConverterManager.register(en.getKey(), converter);
            }
        }
        LOG.info("Registered " + this.propertyConverterManager.getPropertyConverters().size() + " property converters: " + this.propertyConverterManager.getPropertyConverters());
        this.propertyValueCombinationPolicy = builder.combinationPolicy;
        if (this.propertyValueCombinationPolicy == null) {
            this.propertyValueCombinationPolicy = (PropertyValueCombinationPolicy)ServiceContextManager.getServiceContext().getService(PropertyValueCombinationPolicy.class);
        }
        if (this.propertyValueCombinationPolicy == null) {
            this.propertyValueCombinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        }
        LOG.info("Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addPropertySources(PropertySource ... propertySourcesToAdd) {
        ReentrantReadWriteLock.WriteLock writeLock = this.propertySourceLock.writeLock();
        try {
            writeLock.lock();
            ArrayList<PropertySource> newPropertySources = new ArrayList<PropertySource>(this.immutablePropertySources);
            newPropertySources.addAll(Arrays.asList(propertySourcesToAdd));
            Collections.sort(newPropertySources, PropertySourceComparator.getInstance());
            this.immutablePropertySources = Collections.unmodifiableList(newPropertySources);
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultConfigurationContext)) {
            return false;
        }
        DefaultConfigurationContext that = (DefaultConfigurationContext)o;
        if (!this.propertyConverterManager.equals(that.propertyConverterManager)) {
            return false;
        }
        if (!this.immutablePropertySources.equals(that.immutablePropertySources)) {
            return false;
        }
        if (!this.immutablePropertyFilters.equals(that.immutablePropertyFilters)) {
            return false;
        }
        return this.getPropertyValueCombinationPolicy().equals(that.getPropertyValueCombinationPolicy());
    }

    public int hashCode() {
        int result = this.propertyConverterManager.hashCode();
        result = 31 * result + this.immutablePropertySources.hashCode();
        result = 31 * result + this.immutablePropertyFilters.hashCode();
        result = 31 * result + this.getPropertyValueCombinationPolicy().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ConfigurationContext{\n");
        b.append("  Property Sources\n");
        b.append("  ----------------\n");
        if (this.immutablePropertySources.isEmpty()) {
            b.append("  No property sources loaded.\n\n");
        } else {
            b.append("  CLASS                         NAME                                                                  ORDINAL SCANNABLE SIZE    STATE     ERROR\n\n");
            for (PropertySource propertySource : this.immutablePropertySources) {
                b.append("  ");
                this.appendFormatted(b, propertySource.getClass().getSimpleName(), 30);
                this.appendFormatted(b, propertySource.getName(), 70);
                this.appendFormatted(b, String.valueOf(PropertySourceComparator.getOrdinal(propertySource)), 8);
                this.appendFormatted(b, String.valueOf(propertySource.isScannable()), 10);
                if (propertySource.isScannable()) {
                    this.appendFormatted(b, String.valueOf(propertySource.getProperties().size()), 8);
                } else {
                    this.appendFormatted(b, "-", 8);
                }
                PropertyValue state = propertySource.get("_state");
                if (state == null) {
                    this.appendFormatted(b, "OK", 10);
                } else {
                    PropertyValue val;
                    this.appendFormatted(b, state.getValue(), 10);
                    if ("ERROR".equals(state.getValue()) && (val = propertySource.get("_exception")) != null) {
                        this.appendFormatted(b, val.getValue(), 30);
                    }
                }
                b.append('\n');
            }
            b.append("\n");
        }
        b.append("  Property Filters\n");
        b.append("  ----------------\n");
        if (this.immutablePropertyFilters.isEmpty()) {
            b.append("  No property filters loaded.\n\n");
        } else {
            b.append("  CLASS                         INFO\n\n");
            for (PropertyFilter propertyFilter : this.getPropertyFilters()) {
                b.append("  ");
                this.appendFormatted(b, propertyFilter.getClass().getSimpleName(), 30);
                b.append(this.removeNewLines(propertyFilter.toString()));
                b.append('\n');
            }
            b.append("\n\n");
        }
        b.append("  Property Converters\n");
        b.append("  -------------------\n");
        b.append("  CLASS                         TYPE                          INFO\n\n");
        for (Map.Entry entry : this.getPropertyConverters().entrySet()) {
            for (PropertyConverter converter : (List)entry.getValue()) {
                b.append("  ");
                this.appendFormatted(b, converter.getClass().getSimpleName(), 30);
                this.appendFormatted(b, ((TypeLiteral)entry.getKey()).getRawType().getSimpleName(), 30);
                b.append(this.removeNewLines(converter.toString()));
                b.append('\n');
            }
        }
        b.append("\n\n");
        b.append("  PropertyValueCombinationPolicy: " + this.getPropertyValueCombinationPolicy().getClass().getName()).append('\n');
        b.append('}');
        return b.toString();
    }

    private void appendFormatted(StringBuilder b, String text, int length) {
        int padding;
        if (text.length() <= length) {
            b.append(text);
            padding = length - text.length();
        } else {
            b.append(text.substring(0, length - 1));
            padding = 1;
        }
        for (int i = 0; i < padding; ++i) {
            b.append(' ');
        }
    }

    private String removeNewLines(String s) {
        return s.replace('\n', ' ').replace('\r', ' ');
    }

    public List<PropertySource> getPropertySources() {
        return this.immutablePropertySources;
    }

    public PropertySource getPropertySource(String name) {
        for (PropertySource ps : this.getPropertySources()) {
            if (!name.equals(ps.getName())) continue;
            return ps;
        }
        return null;
    }

    public <T> void addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        this.propertyConverterManager.register(typeToConvert, propertyConverter);
        LOG.info("Added PropertyConverter: " + propertyConverter.getClass().getName());
    }

    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        return this.propertyConverterManager.getPropertyConverters();
    }

    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        return this.propertyConverterManager.getPropertyConverters(targetType);
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.immutablePropertyFilters;
    }

    public PropertyValueCombinationPolicy getPropertyValueCombinationPolicy() {
        return this.propertyValueCombinationPolicy;
    }

    public ConfigurationContextBuilder toBuilder() {
        return new DefaultConfigurationContextBuilder(this);
    }
}

