/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContextManager;
import org.apache.tamaya.spisupport.ConfigValueEvaluator;
import org.apache.tamaya.spisupport.DefaultConfigValueEvaluator;
import org.apache.tamaya.spisupport.PropertyFiltering;

public class DefaultConfiguration
implements Configuration {
    private static final Logger LOG = Logger.getLogger(DefaultConfiguration.class.getName());
    private final ConfigurationContext configurationContext;
    private ConfigValueEvaluator configEvaluator = this.loadConfigValueEvaluator();

    private ConfigValueEvaluator loadConfigValueEvaluator() {
        ConfigValueEvaluator eval = null;
        try {
            eval = (ConfigValueEvaluator)ServiceContextManager.getServiceContext().getService(ConfigValueEvaluator.class);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load ConfigValueEvaluator from ServiceContext, using default.", e);
        }
        if (eval == null) {
            eval = new DefaultConfigValueEvaluator();
        }
        return eval;
    }

    public DefaultConfiguration(ConfigurationContext configurationContext) {
        this.configurationContext = Objects.requireNonNull(configurationContext);
    }

    public String get(String key) {
        PropertyValue value = this.configEvaluator.evaluteRawValue(key, this.configurationContext);
        if (value == null || value.getValue() == null) {
            return null;
        }
        if ((value = PropertyFiltering.applyFilter(value, this.configurationContext)) != null) {
            return value.getValue();
        }
        return null;
    }

    protected PropertyValue evaluteRawValue(String key) {
        List propertySources = this.configurationContext.getPropertySources();
        PropertyValue filteredValue = null;
        PropertyValueCombinationPolicy combinationPolicy = this.configurationContext.getPropertyValueCombinationPolicy();
        for (PropertySource propertySource : propertySources) {
            filteredValue = combinationPolicy.collect(filteredValue, key, propertySource);
        }
        return filteredValue;
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Map<String, String> getProperties() {
        Map<String, PropertyValue> filtered = PropertyFiltering.applyFilters(this.configEvaluator.evaluateRawValues(this.configurationContext), this.configurationContext);
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertyValue val : filtered.values()) {
            if (val.getValue() == null) continue;
            result.put(val.getKey(), val.getValue());
            result.putAll(val.getMetaEntries());
        }
        return result;
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        return this.convertValue(key, this.get(key), type);
    }

    protected <T> T convertValue(String key, String value, TypeLiteral<T> type) {
        if (value != null) {
            List converters = this.configurationContext.getPropertyConverters(type);
            ConversionContext context = new ConversionContext.Builder((Configuration)this, this.configurationContext, key, type).build();
            for (PropertyConverter converter : converters) {
                try {
                    Object t = converter.convert(value, context);
                    if (t == null) continue;
                    return (T)t;
                }
                catch (Exception e) {
                    LOG.log(Level.FINEST, "PropertyConverter: " + converter + " failed to convert value: " + value, e);
                }
            }
            if (type.equals((Object)TypeLiteral.of(String.class))) {
                return (T)value;
            }
            throw new ConfigException("Unparseable config value for type: " + type.getRawType().getName() + ": " + key + ", supported formats: " + context.getSupportedFormats());
        }
        return null;
    }

    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Configuration with(ConfigOperator operator) {
        return operator.operate((Configuration)this);
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }

    public ConfigurationContext getContext() {
        return this.configurationContext;
    }

    public String toString() {
        return "Configuration{\n " + this.configurationContext + '}';
    }
}

