/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.BasePropertySource;

public class CLIPropertySource
extends BasePropertySource {
    private static String[] args = new String[0];
    private static Map<String, PropertyValue> mainArgs;

    public CLIPropertySource() {
        this((String[])null);
    }

    public CLIPropertySource(String ... args) {
        super("CLI");
        if (args != null) {
            CLIPropertySource.initMainArgs(args);
        }
    }

    public CLIPropertySource(int ordinal, String ... args) {
        if (args != null) {
            CLIPropertySource.initMainArgs(args);
        }
        this.setOrdinal(ordinal);
    }

    public static void initMainArgs(String ... args) {
        CLIPropertySource.args = Objects.requireNonNull(args);
        String argsProp = System.getProperty("main.args");
        if (argsProp != null) {
            CLIPropertySource.args = argsProp.split("\\s");
        }
        Map<String, String> result = null;
        if (CLIPropertySource.args == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            String prefix = System.getProperty("main.args.prefix");
            if (prefix == null) {
                prefix = "";
            }
            String key = null;
            for (String arg : CLIPropertySource.args) {
                if (arg.startsWith("--")) {
                    int index = (arg = arg.substring(2)).indexOf("=");
                    if (index > 0) {
                        key = arg.substring(0, index).trim();
                        result.put(prefix + key, arg.substring(index + 1).trim());
                        key = null;
                        continue;
                    }
                    result.put(prefix + arg, arg);
                    continue;
                }
                if (arg.startsWith("-")) {
                    key = arg.substring(1);
                    continue;
                }
                if (key != null) {
                    result.put(prefix + key, arg);
                    key = null;
                    continue;
                }
                result.put(prefix + arg, arg);
            }
        }
        HashMap finalProps = new HashMap();
        for (Map.Entry en : result.entrySet()) {
            finalProps.put(en.getKey(), PropertyValue.of((String)((String)en.getKey()), (String)((String)en.getValue()), (String)"main-args"));
        }
        mainArgs = Collections.unmodifiableMap(finalProps);
    }

    public Map<String, PropertyValue> getProperties() {
        return Collections.unmodifiableMap(mainArgs);
    }

    @Override
    protected String toStringValues() {
        return super.toStringValues() + "  args=" + Arrays.toString(args) + '\n';
    }

    static {
        CLIPropertySource.initMainArgs(args);
    }
}

