/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spisupport;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public abstract class BasePropertySource
implements PropertySource {
    private int defaultOrdinal;
    private volatile Integer ordinal;
    private String name;

    protected BasePropertySource(String name) {
        this.name = Objects.requireNonNull(name);
        this.defaultOrdinal = 0;
    }

    protected BasePropertySource(int defaultOrdinal) {
        this.name = this.getClass().getSimpleName();
        this.defaultOrdinal = defaultOrdinal;
    }

    protected BasePropertySource(String name, int defaultOrdinal) {
        this.name = Objects.requireNonNull(name);
        this.defaultOrdinal = defaultOrdinal;
    }

    protected BasePropertySource() {
        this(0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public void setDefaultOrdinal(Integer defaultOrdinal) {
        this.defaultOrdinal = defaultOrdinal;
    }

    public int getOrdinal() {
        Integer ordinal = this.ordinal;
        if (ordinal != null) {
            Logger.getLogger(this.getClass().getName()).finest("Using explicit ordinal '" + ordinal + "' for property source: " + this.getName());
            return ordinal;
        }
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.getDefaultOrdinal();
    }

    public int getDefaultOrdinal() {
        return this.defaultOrdinal;
    }

    public PropertyValue get(String key) {
        Map properties = this.getProperties();
        PropertyValue val = (PropertyValue)properties.get(key);
        if (val == null) {
            return null;
        }
        return val;
    }

    public boolean isScannable() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringValues() + '}';
    }

    protected String toStringValues() {
        return "  defaultOrdinal=" + this.defaultOrdinal + '\n' + "  ordinal=" + this.ordinal + '\n' + "  name='" + this.name + '\'' + '\n';
    }
}

