/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.osgi.updater;

import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.logging.Logger;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.ConfigurationChange;
import org.apache.tamaya.osgi.commands.TamayaConfigService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class EventListener
implements ConfigEventListener {
    private static final Logger LOG = Logger.getLogger(EventListener.class.getName());
    private BundleContext context;

    public EventListener(BundleContext context) {
        this.context = context;
    }

    public void onConfigEvent(ConfigEvent<?> event) {
        LOG.finest("Tamya Config change triggered: " + event);
        HashSet<String> changedPids = new HashSet<String>();
        ConfigurationChange cc = (ConfigurationChange)event;
        for (PropertyChangeEvent evt : cc.getChanges()) {
            String key = evt.getPropertyName();
            String pid = this.getPid(key);
            if (pid == null) continue;
            changedPids.add(pid);
        }
        if (changedPids.isEmpty()) {
            LOG.finest("Tamya Config change not targeting OSGI.");
            return;
        }
        LOG.finest("Tamya Config change for pids: " + changedPids);
        ServiceReference pluginRef = this.context.getServiceReference(TamayaConfigService.class);
        TamayaConfigService tamayaPlugin = (TamayaConfigService)this.context.getService(pluginRef);
        for (String pid : changedPids) {
            tamayaPlugin.updateConfig(pid);
        }
    }

    private String getPid(String key) {
        int index0 = key.indexOf("[");
        int index1 = key.indexOf("]");
        if (index0 >= 0 && index1 - index0 > 0) {
            return key.substring(index0 + 1, index1);
        }
        return null;
    }
}

