/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.osgi.updater;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.ConfigEventManager;
import org.apache.tamaya.events.ConfigurationChange;
import org.apache.tamaya.osgi.commands.TamayaConfigService;
import org.apache.tamaya.osgi.updater.EventListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private EventListener listener;
    private static final long DELAY = 5000L;
    private static final long PERIOD = 5000L;
    private Timer updateTimer = new Timer("Tamaya OSGI update monitor.", true);

    public void start(BundleContext context) throws Exception {
        this.listener = new EventListener(context);
        ConfigEventManager.getInstance().addListener((ConfigEventListener)this.listener, ConfigurationChange.class);
        LOG.info("Registered Tamaya getConfig trigger for OSGI.");
        ServiceReference pluginRef = context.getServiceReference(TamayaConfigService.class);
        final TamayaConfigService tamayaPlugin = (TamayaConfigService)context.getService(pluginRef);
        this.updateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ConfigEventManager.getInstance().enableChangeMonitoring(tamayaPlugin.isAutoUpdateEnabled());
            }
        }, 5000L, 5000L);
    }

    public void stop(BundleContext context) throws Exception {
        this.updateTimer.cancel();
        if (this.listener != null) {
            ConfigEventManager.getInstance().removeListener((ConfigEventListener)this.listener, ConfigurationChange.class);
            LOG.info("Unregistered Tamaya getConfig trigger for OSGI.");
            ConfigEventManager.getInstance().enableChangeMonitoring(false);
        }
    }
}

