/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.gogo.shell;

import java.io.IOException;
import java.util.Objects;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.apache.tamaya.osgi.Policy;
import org.apache.tamaya.osgi.commands.ConfigCommands;
import org.apache.tamaya.osgi.commands.TamayaConfigService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SettingsCommands {
    private BundleContext context;

    public SettingsCommands(BundleContext context) {
        this.context = Objects.requireNonNull(context);
    }

    private <T> T getService(Class<T> type) {
        ServiceReference cmRef = this.context.getServiceReference(type);
        return (T)this.context.getService(cmRef);
    }

    @Descriptor(value="Allows to disable/enable Tamaya configuration by default.")
    public void tm_enable(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-e", "--enable"}) @Descriptor(value="if true Tamaya is enabled by default (default=false)") boolean enabled) throws IOException {
        System.out.println(ConfigCommands.setDefaultEnabled((TamayaConfigService)this.getService(TamayaConfigService.class), (boolean)enabled));
    }

    @Descriptor(value="Access if Tamaya is currently enabled by default to change OSGI configuration.")
    public void tm_enabled() {
        System.out.println(ConfigCommands.getDefaultEnabled((TamayaConfigService)this.getService(TamayaConfigService.class)));
    }

    @Descriptor(value="Get the default Tamaya configuration policy.")
    public void tm_policy() throws IOException {
        System.out.println(ConfigCommands.getDefaultOpPolicy((TamayaConfigService)this.getService(TamayaConfigService.class)));
    }

    @Descriptor(value="Set the default Tamaya configuration policy.")
    public void tm_policy_set(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--policy"}) @Descriptor(value="The policy to apply (required), one of: EXTEND, OVERRIDE, UPDATE_ONLY") Policy policy) throws IOException {
        System.out.println(ConfigCommands.setDefaultOpPolicy((TamayaConfigService)this.getService(TamayaConfigService.class), (String)policy.toString()));
    }

    @Descriptor(value="Get info about the current Tamaya configuration settings.")
    public void tm_info() throws IOException {
        System.out.println(ConfigCommands.getInfo((TamayaConfigService)this.getService(TamayaConfigService.class)));
    }

    @Descriptor(value="Flag if Tamaya is automatically triggering OSGI config updates, when according Tamaya configuration changes.")
    public void tm_propagate_updates() throws IOException {
        System.out.println(this.getService(TamayaConfigService.class).isAutoUpdateEnabled());
    }

    @Descriptor(value="Configure if Tamaya is automatically triggering OSGI config updates, when according Tamaya configuration changes.")
    public void tm_propagate_updates_set(boolean enabled) throws IOException {
        System.out.println(ConfigCommands.setAutoUpdateEnabled((TamayaConfigService)this.getService(TamayaConfigService.class), (boolean)enabled));
    }
}

