/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.gogo.shell;

import java.io.IOException;
import java.util.Objects;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.apache.tamaya.osgi.commands.TamayaConfigService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HistoryCommands {
    private BundleContext context;

    private <T> T getService(Class<T> type) {
        ServiceReference cmRef = this.context.getServiceReference(type);
        return (T)this.context.getService(cmRef);
    }

    public HistoryCommands(BundleContext context) {
        this.context = Objects.requireNonNull(context);
    }

    @Descriptor(value="Deletes the getHistory of configuration changes.")
    public void tm_history_delete(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--pid"}) @Descriptor(value="The PID.") String pid) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.HistoryCommands.clearHistory((TamayaConfigService)this.getService(TamayaConfigService.class), (String)pid));
    }

    @Descriptor(value="Deletes the full getHistory of configuration changes.")
    public void tm_history_delete_all() throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.HistoryCommands.clearHistory((TamayaConfigService)this.getService(TamayaConfigService.class), null));
    }

    @Descriptor(value="Read the getHistory of configuration changes.")
    public void tm_history_get(@Parameter(absentValue="", names={"-p", "--pid"}) @Descriptor(value="The PID.") String pid, @Parameter(absentValue="", names={"-t", "--eventtypes"}) @Descriptor(value="The comma separated Event types to filter, valid types are PROPERTY,BEGIN,END") String eventTypes) throws IOException {
        if (eventTypes.isEmpty()) {
            System.out.println(org.apache.tamaya.osgi.commands.HistoryCommands.getHistory((TamayaConfigService)this.getService(TamayaConfigService.class), (String)pid, (String[])new String[0]));
        } else {
            System.out.println(org.apache.tamaya.osgi.commands.HistoryCommands.getHistory((TamayaConfigService)this.getService(TamayaConfigService.class), (String)pid, (String[])eventTypes.split(",")));
        }
    }

    @Descriptor(value="Get the maximum configuration change getHistory getNumChilds.")
    public void tm_history_maxsize() throws IOException {
        System.out.println(String.valueOf(org.apache.tamaya.osgi.commands.HistoryCommands.getMaxHistorySize((TamayaConfigService)this.getService(TamayaConfigService.class))));
    }

    @Descriptor(value="Sets the maximum configuration change getHistory getNumChilds.")
    public void tm_history_maxsize_set(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-s", "--getNumChilds"}) @Descriptor(value="The maximum getNumChilds of getHistory entries stored.") int maxSize) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.HistoryCommands.setMaxHistorySize((TamayaConfigService)this.getService(TamayaConfigService.class), (int)maxSize));
    }
}

