/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.gogo.shell;

import java.io.IOException;
import java.util.Objects;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.apache.tamaya.osgi.Policy;
import org.apache.tamaya.osgi.commands.TamayaConfigService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConfigCommands {
    private BundleContext context;

    private <T> T getService(Class<T> type) {
        ServiceReference cmRef = this.context.getServiceReference(type);
        return (T)this.context.getService(cmRef);
    }

    public ConfigCommands(BundleContext context) {
        this.context = Objects.requireNonNull(context);
    }

    @Descriptor(value="Shows the current Tamaya configuration.")
    public void tm_config(@Parameter(absentValue="", names={"-s", "--section"}) @Descriptor(value="The section start expression to filter.") String section, @Parameter(absentValue="", names={"-p", "--pid"}) @Descriptor(value="The pid to filter (required).") String pid) throws IOException {
        if (pid.isEmpty()) {
            System.out.println(org.apache.tamaya.osgi.commands.ConfigCommands.readTamayaConfig((String)section, null));
        } else {
            System.out.println(org.apache.tamaya.osgi.commands.ConfigCommands.readTamayaConfig4PID((String)pid, (String)section));
        }
    }

    public void tm_apply_config(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--pid"}) @Descriptor(value="The target OSGI component PID.") String pid, @Parameter(absentValue="OVERRIDE", names={"-m", "--opmode"}) @Descriptor(value="Explicitly setCurrent (override) the operation mode to use, one of: EXTEND, OVERRIDE, UPDATE_ONLY") Policy policy, @Parameter(absentValue="false", names={"-d", "--dryrun"}) @Descriptor(value="If setCurrent to true no OSGI configuration gets changed.") boolean dryRun) {
        System.out.println(org.apache.tamaya.osgi.commands.ConfigCommands.applyTamayaConfiguration((TamayaConfigService)this.getService(TamayaConfigService.class), (String)pid, (String)policy.toString(), (boolean)dryRun));
    }

    @Descriptor(value="Gets the detailed property values.")
    public void tm_property(@Parameter(absentValue="", names={"-ps", "--propertysource"}) @Descriptor(value="The property source name") String propertysource, @Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-k", "--key"}) @Descriptor(value="The property key") String key, @Parameter(absentValue="false", names={"-e", "--extended"}) @Descriptor(value="Show extended info, default=false") Boolean extended) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.ConfigCommands.getProperty((String)propertysource, (String)key, (boolean)extended));
    }

    @Descriptor(value="Get details of a property source.")
    public void tm_propertysource(@Parameter(absentValue="", names={"-ps", "--propertysource"}) @Descriptor(value="The property source name, empty returns a createList of possible values") String propertysource) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.ConfigCommands.getPropertySource((String)propertysource));
    }

    @Descriptor(value="Show details of all registered property sources.")
    public void tm_propertysources() throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.ConfigCommands.getPropertySourceOverview());
    }
}

