/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.gogo.shell;

import java.io.IOException;
import java.util.Objects;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.apache.tamaya.osgi.commands.TamayaConfigService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;

public class BackupCommands {
    private BundleContext context;

    public BackupCommands(BundleContext context) {
        this.context = Objects.requireNonNull(context);
    }

    private <T> T getService(Class<T> type) {
        ServiceReference cmRef = this.context.getServiceReference(type);
        return (T)this.context.getService(cmRef);
    }

    @Descriptor(value="Creates an OSGI ConfigAdmin configuration backup for a PID.")
    public void tm_backup_create(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--pid"}) @Descriptor(value="The PID (requred)") String pid, @Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-f", "--force"}) @Descriptor(value="If setCurrent any existing backup will be overriden, default is false.") Boolean force) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.BackupCommands.createBackup((TamayaConfigService)this.getService(TamayaConfigService.class), (ConfigurationAdmin)this.getService(ConfigurationAdmin.class), (String)pid, (boolean)force));
    }

    @Descriptor(value="Deletes an OSGI ConfigAdmin configuration backup for a PID.")
    public void tm_backup_delete(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--pid"}) @Descriptor(value="The target PID") String pid) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.BackupCommands.deleteBackup((TamayaConfigService)this.getService(TamayaConfigService.class), (String)pid));
    }

    @Descriptor(value="Restores an OSGI ConfigAdmin configuration backup for a PID and disabled Tamaya for the given PID.")
    public void tm_backup_restore(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--pid"}) @Descriptor(value="The target PID") String pid) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.BackupCommands.restoreBackup((TamayaConfigService)this.getService(TamayaConfigService.class), (String)pid));
    }

    @Descriptor(value="Shows the contents of the OSGI ConfigAdmin configuration backup for a PID.")
    public void tm_backup_get(@Parameter(absentValue="org.apache.felix.service.command.unspecified.parameter", names={"-p", "--pid"}) @Descriptor(value="The PID (requred)") String pid) throws IOException {
        System.out.println(org.apache.tamaya.osgi.commands.BackupCommands.listBackup((TamayaConfigService)this.getService(TamayaConfigService.class), (String)Objects.requireNonNull(pid)));
    }
}

