/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.gogo.shell;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.tamaya.gogo.shell.BackupCommands;
import org.apache.tamaya.gogo.shell.ConfigCommands;
import org.apache.tamaya.gogo.shell.HistoryCommands;
import org.apache.tamaya.gogo.shell.SettingsCommands;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private ServiceRegistration<HistoryCommands> histReg;
    private ServiceRegistration<ConfigCommands> configReg;
    private ServiceRegistration<BackupCommands> backupReg;
    private ServiceRegistration<SettingsCommands> settingsReg;

    public void start(BundleContext context) throws Exception {
        LOG.finest("Registering Tamaya commands...");
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", "tamaya");
        ((Dictionary)props).put("osgi.command.function", new String[]{"tm_config", "tm_property", "tm_propertysource", "tm_propertysources"});
        this.configReg = context.registerService(ConfigCommands.class, (Object)new ConfigCommands(context), props);
        ((Dictionary)props).put("osgi.command.function", new String[]{"tm_history", "tm_history_delete", "tm_history_delete_all", "tm_history_maxsize", "tm_history_maxsize_set"});
        this.histReg = context.registerService(HistoryCommands.class, (Object)new HistoryCommands(context), props);
        ((Dictionary)props).put("osgi.command.function", new String[]{"tm_backup_create", "tm_backup_delete", "tm_backup", "tm_backup_restore"});
        this.backupReg = context.registerService(BackupCommands.class, (Object)new BackupCommands(context), props);
        ((Dictionary)props).put("osgi.command.function", new String[]{"tm_enable", "tm_enabled", "tm_policy", "tm_policy_set", "tm_info", "tm_propagate_updates", "tm_propagate_updates_set"});
        this.settingsReg = context.registerService(SettingsCommands.class, (Object)new SettingsCommands(context), props);
        LOG.info("Registered Tamaya commands.");
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info("Unregistering Tamaya commands.");
        if (this.histReg != null) {
            this.histReg.unregister();
        }
        if (this.configReg != null) {
            this.configReg.unregister();
        }
        if (this.backupReg != null) {
            this.backupReg.unregister();
        }
        if (this.settingsReg != null) {
            this.settingsReg.unregister();
        }
    }
}

