/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.functions.Supplier;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.BasePropertySource;

public class MappedConfigurationDataPropertySource
extends BasePropertySource {
    private static final Logger LOG = Logger.getLogger(MappedConfigurationDataPropertySource.class.getName());
    private Map<String, String> properties;
    private final Supplier<ConfigurationData> dataSupplier;

    public MappedConfigurationDataPropertySource(String name, Supplier<ConfigurationData> dataSupplier) {
        this(name, 0, dataSupplier);
    }

    public MappedConfigurationDataPropertySource(final ConfigurationData data) {
        this(data.getResource(), 0, new Supplier<ConfigurationData>(){

            public ConfigurationData get() {
                return data;
            }
        });
    }

    public MappedConfigurationDataPropertySource(int defaultOrdinal, final ConfigurationData data) {
        this(data.getResource(), defaultOrdinal, new Supplier<ConfigurationData>(){

            public ConfigurationData get() {
                return data;
            }
        });
    }

    public MappedConfigurationDataPropertySource(String name, int defaultOrdinal, Supplier<ConfigurationData> dataSupplier) {
        super(defaultOrdinal);
        this.setName(name);
        this.dataSupplier = dataSupplier;
        this.load();
    }

    public void load() {
        try {
            this.properties = this.populateData((ConfigurationData)this.dataSupplier.get());
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to load property source: " + this.getName(), e);
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put("_exception", e.getLocalizedMessage());
            this.properties.put("_state", "ERROR");
        }
        finally {
            this.properties.put("_timestamp", String.valueOf(System.currentTimeMillis()));
        }
    }

    protected Map<String, String> populateData(ConfigurationData data) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (data != null) {
            for (String section : data.getSectionNames()) {
                for (Map.Entry<String, String> en : data.getSection(section).entrySet()) {
                    if ("default".equals(section)) {
                        result.put(en.getKey(), en.getValue());
                        continue;
                    }
                    result.put(section + '.' + en.getKey(), en.getValue());
                }
            }
            result.put("_propertySource", this.getName());
            result.put("_source", data.getResource());
        }
        return result;
    }

    public PropertyValue get(String key) {
        String val = this.properties.get(key);
        return PropertyValue.of((String)key, (String)val, (String)this.getName());
    }

    public Map<String, PropertyValue> getProperties() {
        HashMap<String, PropertyValue> result = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, String> en : this.properties.entrySet()) {
            result.put(en.getKey(), PropertyValue.of((String)en.getKey(), (String)en.getValue(), (String)this.getName()));
        }
        return result;
    }

    protected String toStringValues() {
        return super.toStringValues() + "  dataSupplier=" + this.dataSupplier + '\n';
    }
}

