/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.format.InputStreamFactory;
import org.apache.tamaya.format.MappedConfigurationDataPropertySource;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigurationFormats {
    private static final Logger LOG = Logger.getLogger(ConfigurationFormats.class.getName());

    private ConfigurationFormats() {
    }

    public static List<ConfigurationFormat> getFormats() {
        return ServiceContextManager.getServiceContext().getServices(ConfigurationFormat.class);
    }

    public static List<ConfigurationFormat> getFormats(String ... formatNames) {
        ArrayList<ConfigurationFormat> result = new ArrayList<ConfigurationFormat>();
        HashSet<String> names = new HashSet<String>(Arrays.asList(formatNames));
        for (ConfigurationFormat f : ConfigurationFormats.getFormats()) {
            if (!names.contains(f.getName())) continue;
            result.add(f);
        }
        return result;
    }

    public static List<ConfigurationFormat> getFormats(URL url) {
        List<ConfigurationFormat> formats = ConfigurationFormats.getFormats();
        ArrayList<ConfigurationFormat> result = new ArrayList<ConfigurationFormat>();
        for (ConfigurationFormat f : formats) {
            if (!f.accepts(url)) continue;
            result.add(f);
        }
        return result;
    }

    public static ConfigurationData readConfigurationData(URL url) throws IOException {
        List<ConfigurationFormat> formats = ConfigurationFormats.getFormats(url);
        return ConfigurationFormats.readConfigurationData(url, formats.toArray(new ConfigurationFormat[formats.size()]));
    }

    public static ConfigurationData readConfigurationData(URL url, ConfigurationFormat ... formats) throws IOException {
        return ConfigurationFormats.readConfigurationData(url, Arrays.asList(formats));
    }

    public static ConfigurationData readConfigurationData(URL url, Collection<ConfigurationFormat> formats) throws IOException {
        return ConfigurationFormats.readConfigurationData(url.toString(), url.openStream(), formats);
    }

    public static Collection<ConfigurationData> readConfigurationData(Collection<URL> urls, ConfigurationFormat ... formats) {
        return ConfigurationFormats.readConfigurationData(urls, Arrays.asList(formats));
    }

    public static Collection<ConfigurationData> readConfigurationData(Collection<URL> urls, Collection<ConfigurationFormat> formats) {
        ArrayList<ConfigurationData> dataRead = new ArrayList<ConfigurationData>();
        for (URL url : urls) {
            try {
                ConfigurationData data = ConfigurationFormats.readConfigurationData(url, formats);
                if (data == null) continue;
                dataRead.add(data);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error reading file: " + url.toExternalForm(), e);
            }
        }
        return dataRead;
    }

    public static ConfigurationData readConfigurationData(String resource, InputStream inputStream, ConfigurationFormat ... formats) throws IOException {
        return ConfigurationFormats.readConfigurationData(resource, inputStream, Arrays.asList(formats));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigurationData readConfigurationData(String resource, InputStream inputStream, Collection<ConfigurationFormat> formats) throws IOException {
        Objects.requireNonNull(resource, "Config resource required for traceability.");
        try (InputStreamFactory isFactory = new InputStreamFactory(Objects.requireNonNull(inputStream));){
            Iterator<ConfigurationFormat> iterator = formats.iterator();
            while (iterator.hasNext()) {
                Throwable throwable;
                InputStream is;
                block31: {
                    ConfigurationFormat format = iterator.next();
                    try {
                        ConfigurationData configurationData;
                        block32: {
                            is = isFactory.createInputStream();
                            throwable = null;
                            try {
                                ConfigurationData data = format.readConfiguration(resource, is);
                                if (data == null) break block31;
                                configurationData = data;
                                if (is == null) return configurationData;
                                if (throwable == null) break block32;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (is == null) throw throwable5;
                                    if (throwable == null) {
                                        is.close();
                                        throw throwable5;
                                    }
                                    try {
                                        is.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                            }
                            try {
                                is.close();
                                return configurationData;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return configurationData;
                            }
                        }
                        is.close();
                        return configurationData;
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "Format " + format.getClass().getName() + " failed to read resource " + resource, e);
                        continue;
                    }
                }
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
            return null;
        }
    }

    public static PropertySource createPropertySource(URL url, ConfigurationFormat ... formats) throws IOException {
        return ConfigurationFormats.createPropertySource(url.toString(), url.openStream(), formats);
    }

    public static PropertySource createPropertySource(URL url, Collection<ConfigurationFormat> formats) throws IOException {
        return ConfigurationFormats.createPropertySource(url.toString(), url.openStream(), formats);
    }

    public static PropertySource createPropertySource(String resource, InputStream inputStream, ConfigurationFormat ... formats) {
        return ConfigurationFormats.createPropertySource(resource, inputStream, Arrays.asList(formats));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PropertySource createPropertySource(String resource, InputStream inputStream, Collection<ConfigurationFormat> formats) {
        Objects.requireNonNull(resource, "Config resource required for traceability.");
        try (InputStreamFactory isFactory = new InputStreamFactory(Objects.requireNonNull(inputStream));){
            if (formats.isEmpty()) {
                formats = ConfigurationFormats.getFormats();
            }
            Iterator<ConfigurationFormat> iterator = formats.iterator();
            while (iterator.hasNext()) {
                Throwable throwable;
                InputStream is;
                block34: {
                    ConfigurationFormat format = iterator.next();
                    try {
                        MappedConfigurationDataPropertySource mappedConfigurationDataPropertySource;
                        block35: {
                            is = isFactory.createInputStream();
                            throwable = null;
                            try {
                                ConfigurationData data = format.readConfiguration(resource, is);
                                if (data == null) break block34;
                                mappedConfigurationDataPropertySource = new MappedConfigurationDataPropertySource(data);
                                if (is == null) return mappedConfigurationDataPropertySource;
                                if (throwable == null) break block35;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (is == null) throw throwable3;
                                    if (throwable == null) {
                                        is.close();
                                        throw throwable3;
                                    }
                                    try {
                                        is.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                is.close();
                                return mappedConfigurationDataPropertySource;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                return mappedConfigurationDataPropertySource;
                            }
                        }
                        is.close();
                        return mappedConfigurationDataPropertySource;
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "Format " + format.getClass().getName() + " failed to read resource " + resource, e);
                        continue;
                    }
                }
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
            throw new ConfigException("No matching format found for " + resource + ", tried: " + formats);
        }
        catch (IOException ioe) {
            throw new ConfigException("Failed to read from input stream for " + resource, (Throwable)ioe);
        }
    }
}

