/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;

public final class ConfigurationDataBuilder {
    final ConfigurationFormat format;
    final String resource;
    Map<String, Map<String, String>> namedSections = new HashMap<String, Map<String, String>>();

    private ConfigurationDataBuilder(String resource, ConfigurationFormat format) {
        this.format = Objects.requireNonNull(format);
        this.resource = Objects.requireNonNull(resource);
    }

    public static ConfigurationDataBuilder of(String resource, ConfigurationFormat format) {
        return new ConfigurationDataBuilder(resource, format);
    }

    public static ConfigurationDataBuilder of(ConfigurationData data) {
        ConfigurationDataBuilder b = new ConfigurationDataBuilder(data.getResource(), data.getFormat());
        if (!data.isEmpty()) {
            for (String section : data.getSectionNames()) {
                b.addSectionProperties(section, data.getSection(section));
            }
        }
        return b;
    }

    public ConfigurationDataBuilder addSections(String ... sections) {
        for (String section : sections) {
            if (this.namedSections.containsKey(section)) continue;
            this.namedSections.put(section, new HashMap());
        }
        return this;
    }

    public ConfigurationDataBuilder addSectionProperty(String section, String key, String value) {
        Map<String, String> map = this.namedSections.get(section);
        if (map == null) {
            map = new HashMap<String, String>();
            this.namedSections.put(section, map);
        }
        map.put(key, value);
        return this;
    }

    public ConfigurationDataBuilder addDefaultProperty(String key, String value) {
        return this.addSectionProperty("default", key, value);
    }

    @Deprecated
    public ConfigurationDataBuilder addProperty(String key, String value) {
        return this.addDefaultProperty(key, value);
    }

    public ConfigurationDataBuilder addSectionProperties(String section, Map<String, String> properties) {
        Map<String, String> map = this.namedSections.get(section);
        if (map == null) {
            map = new HashMap<String, String>();
            this.namedSections.put(section, map);
        }
        map.putAll(properties);
        return this;
    }

    @Deprecated
    public ConfigurationDataBuilder addProperties(Map<String, String> properties) {
        return this.addDefaultProperties(properties);
    }

    public ConfigurationDataBuilder addDefaultProperties(Map<String, String> properties) {
        Map<String, String> defaultProps = this.namedSections.get("default");
        if (defaultProps == null) {
            defaultProps = new HashMap<String, String>();
            this.namedSections.put("default", defaultProps);
        }
        defaultProps.putAll(properties);
        return this;
    }

    public Set<String> getSectionNames() {
        return this.namedSections.keySet();
    }

    public ConfigurationData build() {
        return new ConfigurationData(this);
    }

    public String toString() {
        return "ConfigurationDataBuilder{\n  format=" + this.format + "\n  sections=" + this.namedSections.keySet() + "\n  resource=" + this.resource + "\n}";
    }
}

