/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tamaya.format.ConfigurationDataBuilder;
import org.apache.tamaya.format.ConfigurationFormat;

public final class ConfigurationData {
    public static final String DEFAULT_SECTION_NAME = "default";
    private Map<String, Map<String, String>> namedSections = new HashMap<String, Map<String, String>>();
    private final ConfigurationFormat format;
    private final String resource;

    ConfigurationData(ConfigurationDataBuilder builder) {
        this.format = builder.format;
        this.resource = builder.resource;
        this.namedSections.putAll(builder.namedSections);
    }

    public ConfigurationFormat getFormat() {
        return this.format;
    }

    public String getResource() {
        return this.resource;
    }

    public Set<String> getSectionNames() {
        if (this.namedSections == null) {
            return Collections.emptySet();
        }
        return this.namedSections.keySet();
    }

    public Map<String, String> getSection(String name) {
        return this.namedSections.get(name);
    }

    public Map<String, String> getDefaultProperties() {
        Map<String, String> props = this.getSection(DEFAULT_SECTION_NAME);
        if (props != null) {
            return Collections.unmodifiableMap(props);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getCombinedProperties() {
        HashMap<String, String> combinedProperties = new HashMap<String, String>();
        for (String sectionName : this.getSectionNames()) {
            Map<String, String> section = this.getSection(sectionName);
            for (Map.Entry<String, String> en : section.entrySet()) {
                String key = sectionName + "::" + en.getKey();
                combinedProperties.put(key, en.getValue());
            }
        }
        return combinedProperties;
    }

    public boolean containsSection(String section) {
        return this.namedSections.containsKey(section);
    }

    public boolean hasDefaultProperties() {
        return this.containsSection(DEFAULT_SECTION_NAME);
    }

    public boolean isEmpty() {
        return !this.namedSections.isEmpty();
    }

    public String toString() {
        return "ConfigurationData{\n  format        = " + this.format + "\n, resource      = " + this.resource + "\n, sections      = " + this.namedSections.keySet() + "\n  default count = " + this.getDefaultProperties().size() + '}';
    }
}

