/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;

public abstract class BaseFormatPropertySourceProvider
implements PropertySourceProvider {
    private static final Logger LOG = Logger.getLogger(BaseFormatPropertySourceProvider.class.getName());
    private final List<ConfigurationFormat> configFormats = new ArrayList<ConfigurationFormat>();
    private final Collection<URL> paths = new ArrayList<URL>();

    public BaseFormatPropertySourceProvider(List<ConfigurationFormat> formats, URL ... paths) {
        this.configFormats.addAll((Collection<ConfigurationFormat>)Objects.requireNonNull(formats));
        this.paths.addAll(Arrays.asList((Object[])Objects.requireNonNull(paths)));
    }

    public BaseFormatPropertySourceProvider(List<ConfigurationFormat> formats, String ... paths) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.configFormats.addAll((Collection<ConfigurationFormat>)Objects.requireNonNull(formats));
        for (String path : paths) {
            Enumeration<URL> urls;
            try {
                urls = cl.getResources(path);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to read resource: " + path, e);
                continue;
            }
            while (urls.hasMoreElements()) {
                this.paths.add(urls.nextElement());
            }
        }
    }

    public BaseFormatPropertySourceProvider(List<ConfigurationFormat> formats, ClassLoader classLoader, String ... paths) {
        this.configFormats.addAll((Collection<ConfigurationFormat>)Objects.requireNonNull(formats));
        for (String path : paths) {
            Enumeration<URL> urls;
            try {
                urls = classLoader.getResources(path);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to read resource: " + path, e);
                continue;
            }
            while (urls.hasMoreElements()) {
                this.paths.add(urls.nextElement());
            }
        }
    }

    protected abstract Collection<PropertySource> getPropertySources(ConfigurationData var1);

    public Collection<PropertySource> getPropertySources() {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        for (URL res : this.paths) {
            try {
                for (ConfigurationFormat format : this.configFormats) {
                    try {
                        InputStream inputStream = res.openStream();
                        Throwable throwable = null;
                        try {
                            if (!format.accepts(res)) continue;
                            ConfigurationData data = format.readConfiguration(res.toString(), inputStream);
                            propertySources.addAll(this.getPropertySources(data));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Failed to put resource based config: " + res, e);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to put resource based config: " + res, e);
            }
        }
        return propertySources;
    }
}

