/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.features;

import java.util.Objects;
import javax.naming.InitialContext;

public final class Features {
    private Features() {
    }

    public static boolean eventsAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.events.ConfigEventManager");
    }

    public static boolean formatsAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.format.ConfigurationFormats");
    }

    public static boolean tamayaCoreAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.core.internal.CoreConfiguration");
    }

    public static boolean injectionStandaloneAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.inject.ConfigurationInjector");
    }

    public static boolean injectionCDIAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.cdi.DefaultDynamicValue");
    }

    public static boolean mutableConfigAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.mutableconfig.MutableConfigurationProvider");
    }

    public static boolean optionalAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.optional.OptionalConfiguration");
    }

    public static boolean resolverAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.resolver.Resolver");
    }

    public static boolean resourcesAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.resource.ConfigResources");
    }

    public static boolean spiSupportAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.spisupport.PropertySourceComparator");
    }

    public static boolean filterSupportAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.filter.ThreadFilterContext");
    }

    public static boolean springAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.integration.spring.EnableTamayaConfig");
    }

    public static boolean jndiAvailable() {
        return Features.checkClassIsLoadable("org.apache.tamaya.jndi.JNDIPropertySource");
    }

    public static boolean extSpringCoreAvailable() {
        return Features.checkClassIsLoadable("org.springframework.core.env.Environment");
    }

    public static boolean extOSGIAvailable() {
        return Features.checkClassIsLoadable("org.osgi.framework.BundleContext");
    }

    public static boolean extJndiAvailable() {
        try {
            new InitialContext();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkClassIsLoadable(String classname) {
        return Features.checkClassIsLoadable(classname, Thread.currentThread().getContextClassLoader());
    }

    public static boolean checkClassIsLoadable(String classname, ClassLoader classLoader) {
        try {
            Class.forName(Objects.requireNonNull(classname), false, classLoader);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

