/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.etcd;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class EtcdBackendConfig {
    private static final Logger LOG = Logger.getLogger(EtcdBackendConfig.class.getName());
    private static final String TAMAYA_ETCD_SERVER_URLS = "tamaya.etcd.server";
    private static final String TAMAYA_ETCD_TIMEOUT = "tamaya.etcd.timeout";
    private static final String TAMAYA_ETCD_DIRECTORY = "tamaya.etcd.directory";

    private EtcdBackendConfig() {
    }

    public static String getEtcdDirectory() {
        String val = System.getProperty(TAMAYA_ETCD_DIRECTORY);
        if (val == null) {
            val = System.getenv(TAMAYA_ETCD_DIRECTORY);
        }
        if (val != null) {
            return val;
        }
        return "";
    }

    public static long getEtcdTimeout() {
        String val = System.getProperty(TAMAYA_ETCD_TIMEOUT);
        if (val == null) {
            val = System.getenv(TAMAYA_ETCD_TIMEOUT);
        }
        if (val != null) {
            return TimeUnit.MILLISECONDS.convert(Integer.parseInt(val), TimeUnit.SECONDS);
        }
        return 2000L;
    }

    public static List<String> getServers() {
        String serverURLs = System.getProperty(TAMAYA_ETCD_SERVER_URLS);
        if (serverURLs == null) {
            serverURLs = System.getenv(TAMAYA_ETCD_SERVER_URLS);
        }
        if (serverURLs == null) {
            serverURLs = "http://127.0.0.1:2379";
        }
        ArrayList<String> servers = new ArrayList<String>();
        for (String url : serverURLs.split("\\,")) {
            try {
                servers.add(url.trim());
                LOG.info("Using etcd endoint: " + url);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error initializing etcd accessor for URL: " + url, e);
            }
        }
        return servers;
    }
}

