/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.etcd;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

class EtcdAccessor {
    private static final Logger LOG = Logger.getLogger(EtcdAccessor.class.getName());
    private int timeout;
    private final int socketTimeout = 1000;
    private final int connectTimeout = 1000;
    public static final String JOHNZON_SUPPORTS_COMMENTS_PROP = "org.apache.johnzon.supports-comments";
    private final JsonReaderFactory readerFactory = this.initReaderFactory();
    private final String serverURL;

    private JsonReaderFactory initReaderFactory() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put(JOHNZON_SUPPORTS_COMMENTS_PROP, true);
        return Json.createReaderFactory(config);
    }

    public EtcdAccessor(String server) {
        this(server, 2);
    }

    public EtcdAccessor(String server, int timeout) {
        this.timeout = timeout;
        this.serverURL = server.endsWith("/") ? server.substring(0, server.length() - 1) : server;
    }

    public String getVersion() {
        String string;
        block16: {
            String version = "<ERROR>";
            CloseableHttpClient httpclient = HttpClients.createDefault();
            Throwable throwable = null;
            try {
                HttpGet httpGet = new HttpGet(this.serverURL + "/version");
                httpGet.setConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(1000).setConnectTimeout(this.timeout).build());
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                    if (response.getStatusLine().getStatusCode() == 200) {
                        HttpEntity entity = response.getEntity();
                        version = EntityUtils.toString((HttpEntity)entity);
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
                string = version;
                if (httpclient == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (httpclient != null) {
                            EtcdAccessor.$closeResource(throwable, (AutoCloseable)httpclient);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Error getting etcd version from: " + this.serverURL, e);
                    return version;
                }
            }
            EtcdAccessor.$closeResource(throwable, (AutoCloseable)httpclient);
        }
        return string;
    }

    public Map<String, String> get(String key) {
        HashMap<String, String> result;
        block26: {
            result = new HashMap<String, String>();
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpGet httpGet = new HttpGet(this.serverURL + "/v2/keys/" + key);
                httpGet.setConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(1000).setConnectionRequestTimeout(this.timeout).setConnectTimeout(1000).build());
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                    if (response.getStatusLine().getStatusCode() == 200) {
                        HttpEntity entity = response.getEntity();
                        try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(EntityUtils.toString((HttpEntity)entity)));){
                            JsonObject o = reader.readObject();
                            JsonObject node = o.getJsonObject("node");
                            if (node.containsKey((Object)"value")) {
                                result.put(key, node.getString("value"));
                                result.put("_" + key + ".source", "[etcd]" + this.serverURL);
                            }
                            if (node.containsKey((Object)"createdIndex")) {
                                result.put("_" + key + ".createdIndex", String.valueOf(node.getInt("createdIndex")));
                            }
                            if (node.containsKey((Object)"modifiedIndex")) {
                                result.put("_" + key + ".modifiedIndex", String.valueOf(node.getInt("modifiedIndex")));
                            }
                            if (node.containsKey((Object)"expiration")) {
                                result.put("_" + key + ".expiration", String.valueOf(node.getString("expiration")));
                            }
                            if (node.containsKey((Object)"ttl")) {
                                result.put("_" + key + ".ttl", String.valueOf(node.getInt("ttl")));
                            }
                            EntityUtils.consume((HttpEntity)entity);
                            break block26;
                        }
                    }
                    result.put("_" + key + ".NOT_FOUND.target", "[etcd]" + this.serverURL);
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Error reading key '" + key + "' from etcd: " + this.serverURL, e);
                result.put("_ERROR", "Error reading key '" + key + "' from etcd: " + this.serverURL + ": " + e.toString());
            }
        }
        return result;
    }

    public Map<String, String> set(String key, String value) {
        return this.set(key, value, null);
    }

    public Map<String, String> set(String key, String value, Integer ttlSeconds) {
        HashMap<String, String> result;
        block25: {
            result = new HashMap<String, String>();
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpPut put = new HttpPut(this.serverURL + "/v2/keys/" + key);
                put.setConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(1000).setConnectionRequestTimeout(this.timeout).setConnectTimeout(1000).build());
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("value", value));
                if (ttlSeconds != null) {
                    nvps.add(new BasicNameValuePair("ttl", ttlSeconds.toString()));
                }
                put.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)put);){
                    if (response.getStatusLine().getStatusCode() != 201 && response.getStatusLine().getStatusCode() != 200) break block25;
                    HttpEntity entity = response.getEntity();
                    try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(EntityUtils.toString((HttpEntity)entity)));){
                        JsonObject o = reader.readObject();
                        JsonObject node = o.getJsonObject("node");
                        if (node.containsKey((Object)"createdIndex")) {
                            result.put("_" + key + ".createdIndex", String.valueOf(node.getInt("createdIndex")));
                        }
                        if (node.containsKey((Object)"modifiedIndex")) {
                            result.put("_" + key + ".modifiedIndex", String.valueOf(node.getInt("modifiedIndex")));
                        }
                        if (node.containsKey((Object)"expiration")) {
                            result.put("_" + key + ".expiration", String.valueOf(node.getString("expiration")));
                        }
                        if (node.containsKey((Object)"ttl")) {
                            result.put("_" + key + ".ttl", String.valueOf(node.getInt("ttl")));
                        }
                        result.put(key, node.getString("value"));
                        result.put("_" + key + ".source", "[etcd]" + this.serverURL);
                        EtcdAccessor.parsePrevNode(key, result, node);
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Error writing to etcd: " + this.serverURL, e);
                result.put("_ERROR", "Error writing '" + key + "' to etcd: " + this.serverURL + ": " + e.toString());
            }
        }
        return result;
    }

    public Map<String, String> delete(String key) {
        HashMap<String, String> result;
        block24: {
            result = new HashMap<String, String>();
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpDelete delete = new HttpDelete(this.serverURL + "/v2/keys/" + key);
                delete.setConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(1000).setConnectionRequestTimeout(this.timeout).setConnectTimeout(1000).build());
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)delete);){
                    if (response.getStatusLine().getStatusCode() != 200) break block24;
                    HttpEntity entity = response.getEntity();
                    try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(EntityUtils.toString((HttpEntity)entity)));){
                        JsonObject o = reader.readObject();
                        JsonObject node = o.getJsonObject("node");
                        if (node.containsKey((Object)"createdIndex")) {
                            result.put("_" + key + ".createdIndex", String.valueOf(node.getInt("createdIndex")));
                        }
                        if (node.containsKey((Object)"modifiedIndex")) {
                            result.put("_" + key + ".modifiedIndex", String.valueOf(node.getInt("modifiedIndex")));
                        }
                        if (node.containsKey((Object)"expiration")) {
                            result.put("_" + key + ".expiration", String.valueOf(node.getString("expiration")));
                        }
                        if (node.containsKey((Object)"ttl")) {
                            result.put("_" + key + ".ttl", String.valueOf(node.getInt("ttl")));
                        }
                        EtcdAccessor.parsePrevNode(key, result, o);
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Error deleting key '" + key + "' from etcd: " + this.serverURL, e);
                result.put("_ERROR", "Error deleting '" + key + "' from etcd: " + this.serverURL + ": " + e.toString());
            }
        }
        return result;
    }

    private static void parsePrevNode(String key, Map<String, String> result, JsonObject o) {
        if (o.containsKey((Object)"prevNode")) {
            JsonObject prevNode = o.getJsonObject("prevNode");
            if (prevNode.containsKey((Object)"createdIndex")) {
                result.put("_" + key + ".prevNode.createdIndex", String.valueOf(prevNode.getInt("createdIndex")));
            }
            if (prevNode.containsKey((Object)"modifiedIndex")) {
                result.put("_" + key + ".prevNode.modifiedIndex", String.valueOf(prevNode.getInt("modifiedIndex")));
            }
            if (prevNode.containsKey((Object)"expiration")) {
                result.put("_" + key + ".prevNode.expiration", String.valueOf(prevNode.getString("expiration")));
            }
            if (prevNode.containsKey((Object)"ttl")) {
                result.put("_" + key + ".prevNode.ttl", String.valueOf(prevNode.getInt("ttl")));
            }
            result.put("_" + key + ".prevNode.value", prevNode.getString("value"));
        }
    }

    public Map<String, String> getProperties(String directory) {
        return this.getProperties(directory, true);
    }

    public Map<String, String> getProperties(String directory, boolean recursive) {
        HashMap<String, String> result;
        block21: {
            result = new HashMap<String, String>();
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpGet get = new HttpGet(this.serverURL + "/v2/keys/" + directory + "?recursive=" + recursive);
                get.setConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(1000).setConnectionRequestTimeout(this.timeout).setConnectTimeout(1000).build());
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);){
                    if (response.getStatusLine().getStatusCode() != 200) break block21;
                    HttpEntity entity = response.getEntity();
                    try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(EntityUtils.toString((HttpEntity)entity)));){
                        JsonObject o = reader.readObject();
                        JsonObject node = o.getJsonObject("node");
                        if (node != null) {
                            this.addNodes(result, node);
                        }
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Error reading properties for '" + directory + "' from etcd: " + this.serverURL, e);
                result.put("_ERROR", "Error reading properties for '" + directory + "' from etcd: " + this.serverURL + ": " + e.toString());
            }
        }
        return result;
    }

    private void addNodes(Map<String, String> result, JsonObject node) {
        if (!node.containsKey((Object)"dir") || "false".equals(((JsonValue)node.get((Object)"dir")).toString())) {
            String key = node.getString("key").substring(1);
            result.put(key, node.getString("value"));
            if (node.containsKey((Object)"createdIndex")) {
                result.put("_" + key + ".createdIndex", String.valueOf(node.getInt("createdIndex")));
            }
            if (node.containsKey((Object)"modifiedIndex")) {
                result.put("_" + key + ".modifiedIndex", String.valueOf(node.getInt("modifiedIndex")));
            }
            if (node.containsKey((Object)"expiration")) {
                result.put("_" + key + ".expiration", String.valueOf(node.getString("expiration")));
            }
            if (node.containsKey((Object)"ttl")) {
                result.put("_" + key + ".ttl", String.valueOf(node.getInt("ttl")));
            }
            result.put("_" + key + ".source", "[etcd]" + this.serverURL);
        } else {
            JsonArray nodes = node.getJsonArray("nodes");
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); ++i) {
                    this.addNodes(result, nodes.getJsonObject(i));
                }
            }
        }
    }

    public String getUrl() {
        return this.serverURL;
    }
}

