/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.etcd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.etcd.EtcdAccessor;
import org.apache.tamaya.mutableconfig.ConfigChangeRequest;
import org.apache.tamaya.mutableconfig.spi.MutablePropertySource;
import org.apache.tamaya.spi.ChangeSupport;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spisupport.propertysource.BasePropertySource;

public abstract class AbstractEtcdPropertySource
extends BasePropertySource
implements MutablePropertySource {
    private static final Logger LOG = Logger.getLogger(AbstractEtcdPropertySource.class.getName());
    private String directory = "";
    private List<String> servers = new ArrayList<String>();
    private List<EtcdAccessor> etcdBackends = new ArrayList<EtcdAccessor>();
    private Map<String, String> metaData = new HashMap<String, String>();
    private AtomicLong timeoutDuration = new AtomicLong(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
    private AtomicLong timeout = new AtomicLong();
    private Map<String, PropertyValue> configMap = new HashMap<String, PropertyValue>();

    public AbstractEtcdPropertySource() {
        this("etcd");
    }

    public AbstractEtcdPropertySource(String name) {
        super(name);
        this.metaData.put("source", "etcd");
    }

    public long getValidUntil() {
        return this.timeout.get();
    }

    public long getCachePeriod() {
        return this.timeoutDuration.get();
    }

    public void setCacheTimeout(long millis) {
        this.timeoutDuration.set(millis);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        if (!Objects.equals(this.directory, directory)) {
            this.directory = Objects.requireNonNull(directory);
            this.refresh();
        }
    }

    public void setServer(List<String> servers) {
        if (!Objects.equals(this.servers, servers)) {
            ArrayList<EtcdAccessor> etcdBackends = new ArrayList<EtcdAccessor>();
            for (String s : servers) {
                etcdBackends.add(new EtcdAccessor(s));
            }
            this.servers = Collections.unmodifiableList(servers);
            this.etcdBackends = etcdBackends;
            this.metaData.put("backends", servers.toString());
            this.refresh();
        }
    }

    public List<String> getServer() {
        return this.servers;
    }

    public void checkRefresh() {
        if (this.timeout.get() < System.currentTimeMillis()) {
            this.refresh();
        }
    }

    public void refresh() {
        for (EtcdAccessor accessor : this.etcdBackends) {
            try {
                Map<String, String> props = accessor.getProperties(this.directory);
                if (!props.containsKey("_ERROR")) {
                    this.configMap = this.mapPrefix(props);
                    this.timeout.set(System.currentTimeMillis() + this.timeoutDuration.get());
                    continue;
                }
                LOG.log(Level.FINE, "etcd error on " + accessor.getUrl() + ": " + props.get("_ERROR"));
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "etcd access failed on " + accessor.getUrl() + ", trying next...", e);
            }
        }
    }

    public int getOrdinal() {
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Configured ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.getDefaultOrdinal();
    }

    public PropertyValue get(String key) {
        this.checkRefresh();
        return this.configMap.get(key);
    }

    public Map<String, PropertyValue> getProperties() {
        this.checkRefresh();
        return this.configMap;
    }

    public ChangeSupport getChangeSupport() {
        return ChangeSupport.SUPPORTED;
    }

    private Map<String, PropertyValue> mapPrefix(Map<String, String> props) {
        HashMap<String, PropertyValue> values = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            PropertyValue val;
            if (entry.getKey().startsWith("_") || (val = (PropertyValue)values.get(entry.getKey())) != null) continue;
            val = PropertyValue.createValue((String)entry.getKey(), (String)"").setMeta("source", (Object)this.getName()).setMeta(this.metaData);
            values.put(entry.getKey(), val);
        }
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("_")) continue;
            String key = entry.getKey().substring(1);
            for (String field : new String[]{".createdIndex", ".modifiedIndex", ".ttl", ".expiration", ".source"}) {
                PropertyValue val;
                if (!key.endsWith(field) || (val = (PropertyValue)values.get(key = key.substring(0, key.length() - field.length()))) == null) continue;
                val.setMeta(field, (Object)entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : values.entrySet()) {
            values.put(entry.getKey(), (PropertyValue)entry.getValue());
        }
        return values;
    }

    public void applyChange(ConfigChangeRequest configChange) {
        for (EtcdAccessor accessor : this.etcdBackends) {
            try {
                for (String string : configChange.getRemovedProperties()) {
                    Map<String, String> res = accessor.delete(string);
                    if (res.get("_ERROR") == null) continue;
                    LOG.info("Failed to remove key from etcd: " + string);
                }
                for (Map.Entry entry : configChange.getAddedProperties().entrySet()) {
                    Map<String, String> res;
                    String key = (String)entry.getKey();
                    Integer ttl = null;
                    int index = ((String)entry.getKey()).indexOf(63);
                    if (index > 0) {
                        String[] queries;
                        key = ((String)entry.getKey()).substring(0, index);
                        String rawQuery = ((String)entry.getKey()).substring(index + 1);
                        for (String query : queries = rawQuery.split("&")) {
                            if (!query.contains("ttl")) continue;
                            int qIdx = query.indexOf(61);
                            ttl = qIdx > 0 ? Integer.valueOf(Integer.parseInt(query.substring(qIdx + 1).trim())) : null;
                        }
                    }
                    if ((res = accessor.set(key, (String)entry.getValue(), ttl)).get("_ERROR") == null) continue;
                    LOG.info("Failed to addPropertyValue key to etcd: " + (String)entry.getKey() + "=" + (String)entry.getValue());
                }
                break;
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "etcd access failed on " + accessor.getUrl() + ", trying next...", e);
            }
        }
    }

    protected String toStringValues() {
        return super.toStringValues() + "  directory=" + this.directory + '\n' + "  servers=" + this.servers + '\n';
    }
}

