/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamay.ext.examples.resolver;

import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;

public class Main {
    private Main() {
    }

    public static void main(String[] args) {
        Configuration cfg = ConfigurationProvider.getConfiguration();
        System.out.println("****************************************************");
        System.out.println("Resolver Example");
        System.out.println("****************************************************");
        System.out.println();
        System.out.println("Example Metadata:");
        System.out.println("\tType        :  " + cfg.get("example.type"));
        System.out.println("\tName        :  " + cfg.get("example.name"));
        System.out.println("\tDescription :  " + cfg.get("example.description"));
        System.out.println("\tVersion     :  " + cfg.get("example.version"));
        System.out.println("\tAuthor      :  " + cfg.get("example.author"));
        System.out.println();
        System.out.println("Resolved Data:");
        System.out.println("\tFullName     :  " + cfg.get("example.fullName"));
        System.out.println("\tFullVersion  :  " + cfg.get("example.fullVersion"));
        System.out.println();
        Main.dump(cfg.getProperties(), System.out);
    }

    private static void dump(Map<String, String> properties, PrintStream stream) {
        stream.println("FULL DUMP:\n\n");
        for (Map.Entry<String, String> en : new TreeMap<String, String>(properties).entrySet()) {
            stream.println(String.format("\t%s = %s", en.getKey(), en.getValue()));
        }
    }

    static {
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(Level.OFF);
    }
}

