/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.org.objectweb.asm.optimizer;

import java.util.Arrays;
import org.apache.tajo.org.objectweb.asm.ClassWriter;
import org.apache.tajo.org.objectweb.asm.Handle;

class Constant {
    char type;
    int intVal;
    long longVal;
    float floatVal;
    double doubleVal;
    String strVal1;
    String strVal2;
    Object objVal3;
    Object[] objVals;
    int hashCode;

    Constant() {
    }

    Constant(Constant i) {
        this.type = i.type;
        this.intVal = i.intVal;
        this.longVal = i.longVal;
        this.floatVal = i.floatVal;
        this.doubleVal = i.doubleVal;
        this.strVal1 = i.strVal1;
        this.strVal2 = i.strVal2;
        this.objVal3 = i.objVal3;
        this.objVals = i.objVals;
        this.hashCode = i.hashCode;
    }

    void set(int intVal) {
        this.type = (char)73;
        this.intVal = intVal;
        this.hashCode = Integer.MAX_VALUE & this.type + intVal;
    }

    void set(long longVal) {
        this.type = (char)74;
        this.longVal = longVal;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)longVal;
    }

    void set(float floatVal) {
        this.type = (char)70;
        this.floatVal = floatVal;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)floatVal;
    }

    void set(double doubleVal) {
        this.type = (char)68;
        this.doubleVal = doubleVal;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)doubleVal;
    }

    void set(char type, String strVal1, String strVal2, String strVal3) {
        this.type = type;
        this.strVal1 = strVal1;
        this.strVal2 = strVal2;
        this.objVal3 = strVal3;
        switch (type) {
            case 'C': 
            case 'S': 
            case 's': 
            case 't': {
                this.hashCode = Integer.MAX_VALUE & type + strVal1.hashCode();
                return;
            }
            case 'T': {
                this.hashCode = Integer.MAX_VALUE & type + strVal1.hashCode() * strVal2.hashCode();
                return;
            }
        }
        this.hashCode = Integer.MAX_VALUE & type + strVal1.hashCode() * strVal2.hashCode() * strVal3.hashCode();
    }

    void set(String name, String desc, Handle bsm, Object[] bsmArgs) {
        this.type = (char)121;
        this.strVal1 = name;
        this.strVal2 = desc;
        this.objVal3 = bsm;
        this.objVals = bsmArgs;
        int hashCode = 121 + name.hashCode() * desc.hashCode() * bsm.hashCode();
        for (int i = 0; i < bsmArgs.length; ++i) {
            hashCode *= bsmArgs[i].hashCode();
        }
        this.hashCode = Integer.MAX_VALUE & hashCode;
    }

    void write(ClassWriter cw) {
        switch (this.type) {
            case 'I': {
                cw.newConst(new Integer(this.intVal));
                break;
            }
            case 'J': {
                cw.newConst(new Long(this.longVal));
                break;
            }
            case 'F': {
                cw.newConst(new Float(this.floatVal));
                break;
            }
            case 'D': {
                cw.newConst(new Double(this.doubleVal));
                break;
            }
            case 'S': {
                cw.newConst(this.strVal1);
                break;
            }
            case 's': {
                cw.newUTF8(this.strVal1);
                break;
            }
            case 'C': {
                cw.newClass(this.strVal1);
                break;
            }
            case 'T': {
                cw.newNameType(this.strVal1, this.strVal2);
                break;
            }
            case 'G': {
                cw.newField(this.strVal1, this.strVal2, (String)this.objVal3);
                break;
            }
            case 'M': {
                cw.newMethod(this.strVal1, this.strVal2, (String)this.objVal3, false);
                break;
            }
            case 'N': {
                cw.newMethod(this.strVal1, this.strVal2, (String)this.objVal3, true);
                break;
            }
            case 'y': {
                cw.newInvokeDynamic(this.strVal1, this.strVal2, (Handle)this.objVal3, this.objVals);
                break;
            }
            case 't': {
                cw.newMethodType(this.strVal1);
                break;
            }
            default: {
                cw.newHandle(this.type - 104 + 1, this.strVal1, this.strVal2, (String)this.objVal3);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Constant)) {
            return false;
        }
        Constant c = (Constant)o;
        if (c.type == this.type) {
            switch (this.type) {
                case 'I': {
                    return c.intVal == this.intVal;
                }
                case 'J': {
                    return c.longVal == this.longVal;
                }
                case 'F': {
                    return Float.compare(c.floatVal, this.floatVal) == 0;
                }
                case 'D': {
                    return Double.compare(c.doubleVal, this.doubleVal) == 0;
                }
                case 'C': 
                case 'S': 
                case 's': 
                case 't': {
                    return c.strVal1.equals(this.strVal1);
                }
                case 'T': {
                    return c.strVal1.equals(this.strVal1) && c.strVal2.equals(this.strVal2);
                }
                case 'y': {
                    return c.strVal1.equals(this.strVal1) && c.strVal2.equals(this.strVal2) && c.objVal3.equals(this.objVal3) && Arrays.equals(c.objVals, this.objVals);
                }
            }
            return c.strVal1.equals(this.strVal1) && c.strVal2.equals(this.strVal2) && c.objVal3.equals(this.objVal3);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

