/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.org.objectweb.asm.optimizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.tajo.org.objectweb.asm.ClassReader;
import org.apache.tajo.org.objectweb.asm.ClassWriter;
import org.apache.tajo.org.objectweb.asm.Handle;
import org.apache.tajo.org.objectweb.asm.Type;
import org.apache.tajo.org.objectweb.asm.commons.Remapper;
import org.apache.tajo.org.objectweb.asm.commons.SimpleRemapper;
import org.apache.tajo.org.objectweb.asm.optimizer.ClassConstantsCollector;
import org.apache.tajo.org.objectweb.asm.optimizer.ClassOptimizer;
import org.apache.tajo.org.objectweb.asm.optimizer.Constant;
import org.apache.tajo.org.objectweb.asm.optimizer.ConstantPool;

public class Shrinker {
    static final HashMap<String, String> MAPPING = new HashMap();

    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        int n = args.length - 1;
        for (int i = 0; i < n - 1; ++i) {
            properties.load(new FileInputStream(args[i]));
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            MAPPING.put((String)entry.getKey(), (String)entry.getValue());
        }
        final HashSet<String> unused = new HashSet<String>(MAPPING.keySet());
        File f = new File(args[n - 1]);
        File d = new File(args[n]);
        Shrinker.optimize(f, d, new SimpleRemapper(MAPPING){

            @Override
            public String map(String key) {
                String s = super.map(key);
                if (s != null) {
                    unused.remove(key);
                }
                return s;
            }
        });
        for (String s : unused) {
            if (s.endsWith("/remove")) continue;
            System.out.println("INFO: unused mapping " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void optimize(File f, File d, Remapper remapper) throws IOException {
        block9: {
            block8: {
                if (!f.isDirectory()) break block8;
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    Shrinker.optimize(files[i], d, remapper);
                }
                break block9;
            }
            if (!f.getName().endsWith(".class")) break block9;
            ConstantPool cp = new ConstantPool();
            ClassReader cr = new ClassReader(new FileInputStream(f));
            ClassWriter cw = new ClassWriter(0);
            ClassConstantsCollector ccc = new ClassConstantsCollector(cw, cp);
            ClassOptimizer co = new ClassOptimizer(ccc, remapper);
            cr.accept(co, 2);
            TreeSet<Constant> constants = new TreeSet<Constant>(new ConstantComparator());
            constants.addAll(cp.values());
            cr = new ClassReader(cw.toByteArray());
            cw = new ClassWriter(0);
            for (Constant c : constants) {
                c.write(cw);
            }
            cr.accept(cw, 2);
            if (MAPPING.get(cr.getClassName() + "/remove") != null) {
                return;
            }
            String n = remapper.mapType(cr.getClassName());
            File g = new File(d, n + ".class");
            if (!g.exists() || g.lastModified() < f.lastModified()) {
                if (!g.getParentFile().exists() && !g.getParentFile().mkdirs()) {
                    throw new IOException("Cannot create directory " + g.getParentFile());
                }
                FileOutputStream os = new FileOutputStream(g);
                try {
                    ((OutputStream)os).write(cw.toByteArray());
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
    }

    static class ConstantComparator
    implements Comparator<Constant> {
        ConstantComparator() {
        }

        @Override
        public int compare(Constant c1, Constant c2) {
            int d = ConstantComparator.getSort(c1) - ConstantComparator.getSort(c2);
            if (d == 0) {
                switch (c1.type) {
                    case 'I': {
                        return new Integer(c1.intVal).compareTo(new Integer(c2.intVal));
                    }
                    case 'J': {
                        return new Long(c1.longVal).compareTo(new Long(c2.longVal));
                    }
                    case 'F': {
                        return new Float(c1.floatVal).compareTo(new Float(c2.floatVal));
                    }
                    case 'D': {
                        return new Double(c1.doubleVal).compareTo(new Double(c2.doubleVal));
                    }
                    case 'C': 
                    case 'S': 
                    case 's': 
                    case 't': {
                        return c1.strVal1.compareTo(c2.strVal1);
                    }
                    case 'T': {
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0) break;
                        d = c1.strVal2.compareTo(c2.strVal2);
                        break;
                    }
                    case 'y': {
                        Handle bsm2;
                        Handle bsm1;
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0 || (d = c1.strVal2.compareTo(c2.strVal2)) != 0 || (d = ConstantComparator.compareHandle(bsm1 = (Handle)c1.objVal3, bsm2 = (Handle)c2.objVal3)) != 0) break;
                        d = ConstantComparator.compareObjects(c1.objVals, c2.objVals);
                        break;
                    }
                    default: {
                        d = c1.strVal1.compareTo(c2.strVal1);
                        if (d != 0 || (d = c1.strVal2.compareTo(c2.strVal2)) != 0) break;
                        d = ((String)c1.objVal3).compareTo((String)c2.objVal3);
                    }
                }
            }
            return d;
        }

        private static int compareHandle(Handle h1, Handle h2) {
            int d = h1.getTag() - h2.getTag();
            if (d == 0 && (d = h1.getOwner().compareTo(h2.getOwner())) == 0 && (d = h1.getName().compareTo(h2.getName())) == 0) {
                d = h1.getDesc().compareTo(h2.getDesc());
            }
            return d;
        }

        private static int compareType(Type mtype1, Type mtype2) {
            return mtype1.getDescriptor().compareTo(mtype2.getDescriptor());
        }

        private static int compareObjects(Object[] objVals1, Object[] objVals2) {
            int length = objVals1.length;
            int d = length - objVals2.length;
            if (d == 0) {
                for (int i = 0; i < length; ++i) {
                    Object objVal1 = objVals1[i];
                    Object objVal2 = objVals2[i];
                    d = objVal1.getClass().getName().compareTo(objVal2.getClass().getName());
                    if (d == 0) {
                        d = objVal1 instanceof Type ? ConstantComparator.compareType((Type)objVal1, (Type)objVal2) : (objVal1 instanceof Handle ? ConstantComparator.compareHandle((Handle)objVal1, (Handle)objVal2) : ((Comparable)objVal1).compareTo(objVal2));
                    }
                    if (d == 0) continue;
                    return d;
                }
            }
            return 0;
        }

        private static int getSort(Constant c) {
            switch (c.type) {
                case 'I': {
                    return 0;
                }
                case 'J': {
                    return 1;
                }
                case 'F': {
                    return 2;
                }
                case 'D': {
                    return 3;
                }
                case 's': {
                    return 4;
                }
                case 'S': {
                    return 5;
                }
                case 'C': {
                    return 6;
                }
                case 'T': {
                    return 7;
                }
                case 'G': {
                    return 8;
                }
                case 'M': {
                    return 9;
                }
                case 'N': {
                    return 10;
                }
                case 'y': {
                    return 11;
                }
                case 't': {
                    return 12;
                }
            }
            return 100 + c.type - 104;
        }
    }
}

