/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.org.objectweb.asm.optimizer;

import org.apache.tajo.org.objectweb.asm.AnnotationVisitor;
import org.apache.tajo.org.objectweb.asm.Attribute;
import org.apache.tajo.org.objectweb.asm.ClassVisitor;
import org.apache.tajo.org.objectweb.asm.FieldVisitor;
import org.apache.tajo.org.objectweb.asm.MethodVisitor;
import org.apache.tajo.org.objectweb.asm.commons.Remapper;
import org.apache.tajo.org.objectweb.asm.commons.RemappingClassAdapter;
import org.apache.tajo.org.objectweb.asm.optimizer.MethodOptimizer;

public class ClassOptimizer
extends RemappingClassAdapter {
    private String pkgName;
    String clsName;
    boolean class$;

    public ClassOptimizer(ClassVisitor cv, Remapper remapper) {
        super(cv, remapper);
    }

    FieldVisitor syntheticFieldVisitor(int access, String name, String desc) {
        return super.visitField(access, name, desc, null, null);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(46, access, name, null, superName, interfaces);
        this.clsName = name;
        int index = name.lastIndexOf(47);
        this.pkgName = index > 0 ? name.substring(0, index) : "";
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String s = this.remapper.mapFieldName(this.className, name, desc);
        if ("-".equals(s)) {
            return null;
        }
        if ((access & 5) == 0) {
            if ((access & 0x10) != 0 && (access & 8) != 0 && desc.length() == 1) {
                return null;
            }
            if ("org/apache/tajo/org/objectweb".equals(this.pkgName) && s.equals(name)) {
                System.out.println("INFO: " + this.clsName + "." + s + " could be renamed");
            }
            super.visitField(access, name, desc, null, value);
        } else {
            if (!s.equals(name)) {
                throw new RuntimeException("The public or protected field " + this.className + '.' + name + " must not be renamed.");
            }
            super.visitField(access, name, desc, null, value);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String s = this.remapper.mapMethodName(this.className, name, desc);
        if ("-".equals(s)) {
            return null;
        }
        if ((access & 5) == 0) {
            if ("org/apache/tajo/org/objectweb".equals(this.pkgName) && !name.startsWith("<") && s.equals(name)) {
                System.out.println("INFO: " + this.clsName + "." + s + " could be renamed");
            }
            return super.visitMethod(access, name, desc, null, exceptions);
        }
        if (!s.equals(name)) {
            throw new RuntimeException("The public or protected method " + this.className + '.' + name + desc + " must not be renamed.");
        }
        return super.visitMethod(access, name, desc, null, exceptions);
    }

    @Override
    protected MethodVisitor createRemappingMethodAdapter(int access, String newDesc, MethodVisitor mv) {
        return new MethodOptimizer(this, access, newDesc, mv, this.remapper);
    }
}

