/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.ProtobufDatumFactory;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.tuple.offheap.HeapTuple;
import org.apache.tajo.util.StringUtils;
import org.apache.tajo.util.UnsafeUtil;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public abstract class UnSafeTuple
implements Tuple {
    private static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    private DirectBuffer bb;
    private int relativePos;
    private int length;
    private TajoDataTypes.DataType[] types;

    protected void set(ByteBuffer bb, int relativePos, int length, TajoDataTypes.DataType[] types) {
        this.bb = (DirectBuffer)((Object)bb);
        this.relativePos = relativePos;
        this.length = length;
        this.types = types;
    }

    void set(ByteBuffer bb, TajoDataTypes.DataType[] types) {
        this.set(bb, 0, bb.limit(), types);
    }

    public int size() {
        return this.types.length;
    }

    public ByteBuffer nioBuffer() {
        return ((ByteBuffer)((ByteBuffer)((Object)this.bb)).duplicate().position(this.relativePos).limit(this.relativePos + this.length)).slice();
    }

    public HeapTuple toHeapTuple() {
        byte[] bytes = new byte[this.length];
        UNSAFE.copyMemory(null, this.bb.address() + (long)this.relativePos, bytes, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, this.length);
        return new HeapTuple(bytes, this.types);
    }

    public void copyFrom(UnSafeTuple tuple) {
        Preconditions.checkNotNull((Object)tuple);
        ((ByteBuffer)((Object)this.bb)).clear();
        if (this.length < tuple.length) {
            UnsafeUtil.free((ByteBuffer)((ByteBuffer)((Object)this.bb)));
            this.bb = (DirectBuffer)((Object)ByteBuffer.allocateDirect(tuple.length).order(ByteOrder.nativeOrder()));
            this.relativePos = 0;
            this.length = tuple.length;
        }
        ((ByteBuffer)((Object)this.bb)).put(tuple.nioBuffer());
    }

    private int getFieldOffset(int fieldId) {
        return UNSAFE.getInt(this.bb.address() + (long)this.relativePos + 4L + (long)(fieldId * 4));
    }

    public long getFieldAddr(int fieldId) {
        int fieldOffset = this.getFieldOffset(fieldId);
        if (fieldOffset == -1) {
            throw new RuntimeException("Invalid Field Access: " + fieldId);
        }
        return this.bb.address() + (long)this.relativePos + (long)fieldOffset;
    }

    public boolean contains(int fieldid) {
        return this.getFieldOffset(fieldid) > -1;
    }

    public boolean isNull(int fieldid) {
        return this.getFieldOffset(fieldid) == -1;
    }

    public boolean isNotNull(int fieldid) {
        return this.getFieldOffset(fieldid) > -1;
    }

    public void clear() {
    }

    public void put(int fieldId, Datum value) {
        throw new UnsupportedException("UnSafeTuple does not support put(int, Datum).");
    }

    public void put(int fieldId, Datum[] values) {
        throw new UnsupportedException("UnSafeTuple does not support put(int, Datum []).");
    }

    public void put(int fieldId, Tuple tuple) {
        throw new UnsupportedException("UnSafeTuple does not support put(int, Tuple).");
    }

    public void put(Datum[] values) {
        throw new UnsupportedException("UnSafeTuple does not support put(Datum []).");
    }

    public Datum get(int fieldId) {
        if (this.isNull(fieldId)) {
            return NullDatum.get();
        }
        switch (this.types[fieldId].getType()) {
            case BOOLEAN: {
                return DatumFactory.createBool((boolean)this.getBool(fieldId));
            }
            case INT1: 
            case INT2: {
                return DatumFactory.createInt2((short)this.getInt2(fieldId));
            }
            case INT4: {
                return DatumFactory.createInt4((int)this.getInt4(fieldId));
            }
            case INT8: {
                return DatumFactory.createInt8((long)this.getInt4(fieldId));
            }
            case FLOAT4: {
                return DatumFactory.createFloat4((float)this.getFloat4(fieldId));
            }
            case FLOAT8: {
                return DatumFactory.createFloat8((double)this.getFloat8(fieldId));
            }
            case TEXT: {
                return DatumFactory.createText((String)this.getText(fieldId));
            }
            case TIMESTAMP: {
                return DatumFactory.createTimestamp((long)this.getInt8(fieldId));
            }
            case DATE: {
                return DatumFactory.createDate((int)this.getInt4(fieldId));
            }
            case TIME: {
                return DatumFactory.createTime((long)this.getInt8(fieldId));
            }
            case INTERVAL: {
                return this.getInterval(fieldId);
            }
            case INET4: {
                return DatumFactory.createInet4((int)this.getInt4(fieldId));
            }
            case PROTOBUF: {
                return this.getProtobufDatum(fieldId);
            }
        }
        throw new UnsupportedException("Unknown type: " + this.types[fieldId]);
    }

    public void setOffset(long offset) {
    }

    public long getOffset() {
        return 0L;
    }

    public boolean getBool(int fieldId) {
        return UNSAFE.getByte(this.getFieldAddr(fieldId)) == 1;
    }

    public byte getByte(int fieldId) {
        return UNSAFE.getByte(this.getFieldAddr(fieldId));
    }

    public char getChar(int fieldId) {
        return UNSAFE.getChar(this.getFieldAddr(fieldId));
    }

    public byte[] getBytes(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int len = UNSAFE.getInt(pos);
        byte[] bytes = new byte[len];
        UNSAFE.copyMemory(null, pos += 4L, bytes, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, len);
        return bytes;
    }

    public short getInt2(int fieldId) {
        long addr = this.getFieldAddr(fieldId);
        return UNSAFE.getShort(addr);
    }

    public int getInt4(int fieldId) {
        return UNSAFE.getInt(this.getFieldAddr(fieldId));
    }

    public long getInt8(int fieldId) {
        return UNSAFE.getLong(this.getFieldAddr(fieldId));
    }

    public float getFloat4(int fieldId) {
        return UNSAFE.getFloat(this.getFieldAddr(fieldId));
    }

    public double getFloat8(int fieldId) {
        return UNSAFE.getDouble(this.getFieldAddr(fieldId));
    }

    public String getText(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int len = UNSAFE.getInt(pos);
        byte[] bytes = new byte[len];
        UNSAFE.copyMemory(null, pos += 4L, bytes, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, len);
        return new String(bytes);
    }

    public IntervalDatum getInterval(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int months = UNSAFE.getInt(pos);
        long millisecs = UNSAFE.getLong(pos += 4L);
        return new IntervalDatum(months, millisecs);
    }

    public Datum getProtobufDatum(int fieldId) {
        byte[] bytes = this.getBytes(fieldId);
        ProtobufDatumFactory factory = ProtobufDatumFactory.get((String)this.types[fieldId].getCode());
        Message.Builder builder = factory.newBuilder();
        try {
            builder.mergeFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            return NullDatum.get();
        }
        return new ProtobufDatum(builder.build());
    }

    public char[] getUnicodeChars(int fieldId) {
        long pos = this.getFieldAddr(fieldId);
        int len = UNSAFE.getInt(pos);
        byte[] bytes = new byte[len];
        UNSAFE.copyMemory(null, pos += 4L, bytes, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, len);
        return StringUtils.convertBytesToChars((byte[])bytes, (Charset)Charset.forName("UTF-8"));
    }

    public Tuple clone() throws CloneNotSupportedException {
        return this.toHeapTuple();
    }

    public Datum[] getValues() {
        Datum[] datums = new Datum[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            datums[i] = this.contains(i) ? this.get(i) : NullDatum.get();
        }
        return datums;
    }

    public String toString() {
        return VTuple.toDisplayString((Datum[])this.getValues());
    }

    public abstract void release();
}

