/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.tuple.offheap.OffHeapMemory;
import org.apache.tajo.tuple.offheap.RowWriter;
import org.apache.tajo.util.UnsafeUtil;

public abstract class OffHeapRowWriter
implements RowWriter {
    private final int headerSize;
    private final int[] fieldOffsets;
    private final TajoDataTypes.DataType[] dataTypes;
    private int curFieldIdx;
    private int curOffset;

    public OffHeapRowWriter(TajoDataTypes.DataType[] dataTypes) {
        this.dataTypes = dataTypes;
        this.fieldOffsets = new int[dataTypes.length];
        this.headerSize = 4 * (dataTypes.length + 1);
    }

    public void clear() {
        this.curOffset = 0;
        this.curFieldIdx = 0;
    }

    public long recordStartAddr() {
        return this.address() + (long)this.position();
    }

    public abstract long address();

    public abstract void ensureSize(int var1);

    public int offset() {
        return this.curOffset;
    }

    public abstract int position();

    public abstract void forward(int var1);

    @Override
    public TajoDataTypes.DataType[] dataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean startRow() {
        this.curOffset = this.headerSize;
        this.curFieldIdx = 0;
        return true;
    }

    @Override
    public void endRow() {
        int i;
        long rowHeaderPos = this.address() + (long)this.position();
        OffHeapMemory.UNSAFE.putInt(rowHeaderPos, this.curOffset);
        rowHeaderPos += 4L;
        for (i = 0; i < this.curFieldIdx; ++i) {
            OffHeapMemory.UNSAFE.putInt(rowHeaderPos, this.fieldOffsets[i]);
            rowHeaderPos += 4L;
        }
        for (i = this.curFieldIdx; i < this.dataTypes.length; ++i) {
            OffHeapMemory.UNSAFE.putInt(rowHeaderPos, -1);
            rowHeaderPos += 4L;
        }
        this.forward(this.curOffset);
    }

    @Override
    public void skipField() {
        this.fieldOffsets[this.curFieldIdx++] = -1;
    }

    private void forwardField() {
        this.fieldOffsets[this.curFieldIdx++] = this.curOffset;
    }

    @Override
    public void putBool(boolean val) {
        this.ensureSize(1);
        this.forwardField();
        OffHeapMemory.UNSAFE.putByte(this.recordStartAddr() + (long)this.curOffset, (byte)(val ? 1 : 0));
        ++this.curOffset;
    }

    @Override
    public void putInt2(short val) {
        this.ensureSize(2);
        this.forwardField();
        OffHeapMemory.UNSAFE.putShort(this.recordStartAddr() + (long)this.curOffset, val);
        this.curOffset += 2;
    }

    @Override
    public void putInt4(int val) {
        this.ensureSize(4);
        this.forwardField();
        OffHeapMemory.UNSAFE.putInt(this.recordStartAddr() + (long)this.curOffset, val);
        this.curOffset += 4;
    }

    @Override
    public void putInt8(long val) {
        this.ensureSize(8);
        this.forwardField();
        OffHeapMemory.UNSAFE.putLong(this.recordStartAddr() + (long)this.curOffset, val);
        this.curOffset += 8;
    }

    @Override
    public void putFloat4(float val) {
        this.ensureSize(4);
        this.forwardField();
        OffHeapMemory.UNSAFE.putFloat(this.recordStartAddr() + (long)this.curOffset, val);
        this.curOffset += 4;
    }

    @Override
    public void putFloat8(double val) {
        this.ensureSize(8);
        this.forwardField();
        OffHeapMemory.UNSAFE.putDouble(this.recordStartAddr() + (long)this.curOffset, val);
        this.curOffset += 8;
    }

    @Override
    public void putText(String val) {
        byte[] bytes = val.getBytes(TextDatum.DEFAULT_CHARSET);
        this.putText(bytes);
    }

    @Override
    public void putText(byte[] val) {
        int bytesLen = val.length;
        this.ensureSize(4 + bytesLen);
        this.forwardField();
        OffHeapMemory.UNSAFE.putInt(this.recordStartAddr() + (long)this.curOffset, bytesLen);
        this.curOffset += 4;
        OffHeapMemory.UNSAFE.copyMemory(val, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, null, this.recordStartAddr() + (long)this.curOffset, bytesLen);
        this.curOffset += bytesLen;
    }

    @Override
    public void putBlob(byte[] val) {
        int bytesLen = val.length;
        this.ensureSize(4 + bytesLen);
        this.forwardField();
        OffHeapMemory.UNSAFE.putInt(this.recordStartAddr() + (long)this.curOffset, bytesLen);
        this.curOffset += 4;
        OffHeapMemory.UNSAFE.copyMemory(val, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, null, this.recordStartAddr() + (long)this.curOffset, bytesLen);
        this.curOffset += bytesLen;
    }

    @Override
    public void putTimestamp(long val) {
        this.putInt8(val);
    }

    @Override
    public void putDate(int val) {
        this.putInt4(val);
    }

    @Override
    public void putTime(long val) {
        this.putInt8(val);
    }

    @Override
    public void putInterval(IntervalDatum val) {
        this.ensureSize(12);
        this.forwardField();
        long offset = this.recordStartAddr() + (long)this.curOffset;
        OffHeapMemory.UNSAFE.putInt(offset, val.getMonths());
        OffHeapMemory.UNSAFE.putLong(offset += 4L, val.getMilliSeconds());
        this.curOffset += 12;
    }

    @Override
    public void putInet4(int val) {
        this.putInt4(val);
    }

    @Override
    public void putProtoDatum(ProtobufDatum val) {
        this.putBlob(val.asByteArray());
    }
}

