/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.offheap.OffHeapRowBlock;
import org.apache.tajo.tuple.offheap.OffHeapRowBlockReader;
import org.apache.tajo.tuple.offheap.ZeroCopyTuple;

public class OffHeapRowBlockUtils {
    public static List<Tuple> sort(OffHeapRowBlock rowBlock, Comparator<Tuple> comparator) {
        ArrayList tupleList = Lists.newArrayList();
        ZeroCopyTuple zcTuple = new ZeroCopyTuple();
        OffHeapRowBlockReader reader = new OffHeapRowBlockReader(rowBlock);
        while (reader.next(zcTuple)) {
            tupleList.add(zcTuple);
            zcTuple = new ZeroCopyTuple();
        }
        Collections.sort(tupleList, comparator);
        return tupleList;
    }

    public static Tuple[] sortToArray(OffHeapRowBlock rowBlock, Comparator<Tuple> comparator) {
        Tuple[] tuples = new Tuple[rowBlock.rows()];
        ZeroCopyTuple zcTuple = new ZeroCopyTuple();
        OffHeapRowBlockReader reader = new OffHeapRowBlockReader(rowBlock);
        for (int i = 0; i < rowBlock.rows() && reader.next(zcTuple); ++i) {
            tuples[i] = zcTuple;
            zcTuple = new ZeroCopyTuple();
        }
        Arrays.sort(tuples, comparator);
        return tuples;
    }
}

