/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.offheap.OffHeapRowBlock;
import org.apache.tajo.tuple.offheap.ZeroCopyTuple;
import org.apache.tajo.util.UnsafeUtil;
import sun.misc.Unsafe;

public class OffHeapRowBlockReader
implements RowBlockReader<ZeroCopyTuple> {
    private static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    OffHeapRowBlock rowBlock;
    private int curRowIdxForRead;
    private int curPosForRead;

    public OffHeapRowBlockReader(OffHeapRowBlock rowBlock) {
        this.rowBlock = rowBlock;
    }

    public long remainForRead() {
        return this.rowBlock.memorySize - this.curPosForRead;
    }

    @Override
    public boolean next(ZeroCopyTuple tuple) {
        if (this.curRowIdxForRead < this.rowBlock.rows()) {
            long recordStartPtr = this.rowBlock.address() + (long)this.curPosForRead;
            int recordLen = UNSAFE.getInt(recordStartPtr);
            tuple.set(this.rowBlock.buffer, this.curPosForRead, recordLen, this.rowBlock.dataTypes);
            this.curPosForRead += recordLen;
            ++this.curRowIdxForRead;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.curPosForRead = 0;
        this.curRowIdxForRead = 0;
    }
}

