/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.catalog.statistics.TableStats;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.tuple.offheap.OffHeapMemory;
import org.apache.tajo.tuple.offheap.OffHeapRowBlockReader;
import org.apache.tajo.tuple.offheap.OffHeapRowBlockWriter;
import org.apache.tajo.tuple.offheap.ResizableLimitSpec;
import org.apache.tajo.tuple.offheap.RowWriter;
import org.apache.tajo.util.Deallocatable;
import org.apache.tajo.util.FileUtil;

public class OffHeapRowBlock
extends OffHeapMemory
implements Deallocatable {
    private static final Log LOG = LogFactory.getLog(OffHeapRowBlock.class);
    public static final int NULL_FIELD_OFFSET = -1;
    TajoDataTypes.DataType[] dataTypes;
    private int maxRowNum = Integer.MAX_VALUE;
    private int rowNum;
    protected int position = 0;
    private OffHeapRowBlockWriter builder;

    private OffHeapRowBlock(ByteBuffer buffer, Schema schema, ResizableLimitSpec limitSpec) {
        super(buffer, limitSpec);
        this.initialize(schema);
    }

    public OffHeapRowBlock(Schema schema, ResizableLimitSpec limitSpec) {
        super(limitSpec);
        this.initialize(schema);
    }

    private void initialize(Schema schema) {
        this.dataTypes = SchemaUtil.toDataTypes((Schema)schema);
        this.builder = new OffHeapRowBlockWriter(this);
    }

    @VisibleForTesting
    public OffHeapRowBlock(Schema schema, int bytes) {
        this(schema, new ResizableLimitSpec(bytes));
    }

    @VisibleForTesting
    public OffHeapRowBlock(Schema schema, ByteBuffer buffer) {
        this(buffer, schema, ResizableLimitSpec.DEFAULT_LIMIT);
    }

    public void position(int pos) {
        this.position = pos;
    }

    public void clear() {
        this.position = 0;
        this.rowNum = 0;
        this.builder.clear();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return (ByteBuffer)this.buffer.position(0).limit(this.position);
    }

    public int position() {
        return this.position;
    }

    public long usedMem() {
        return this.position;
    }

    public void ensureSize(int size) {
        if (this.remain() - (long)size < 0L) {
            if (!this.limitSpec.canIncrease(this.memorySize)) {
                throw new RuntimeException("Cannot increase RowBlock anymore.");
            }
            int newBlockSize = this.limitSpec.increasedSize(this.memorySize);
            this.resize(newBlockSize);
            LOG.info((Object)("Increase DirectRowBlock to " + FileUtil.humanReadableByteCount((long)newBlockSize, (boolean)false)));
        }
    }

    public long remain() {
        return this.memorySize - this.position - this.builder.offset();
    }

    public int maxRowNum() {
        return this.maxRowNum;
    }

    public int rows() {
        return this.rowNum;
    }

    public void setRows(int rowNum) {
        this.rowNum = rowNum;
    }

    public boolean copyFromChannel(FileChannel channel, TableStats stats) throws IOException {
        if (channel.position() < channel.size()) {
            this.clear();
            this.buffer.clear();
            channel.read(this.buffer);
            this.memorySize = this.buffer.position();
            while (this.position < this.memorySize) {
                long recordPtr = this.address + (long)this.position;
                if (this.remain() < 4L) {
                    channel.position(channel.position() - this.remain());
                    this.memorySize = (int)((long)this.memorySize - this.remain());
                    return true;
                }
                int recordSize = UNSAFE.getInt(recordPtr);
                if (this.remain() < (long)recordSize) {
                    channel.position(channel.position() - this.remain());
                    this.memorySize = (int)((long)this.memorySize - this.remain());
                    return true;
                }
                this.position += recordSize;
                ++this.rowNum;
            }
            return true;
        }
        return false;
    }

    public RowWriter getWriter() {
        return this.builder;
    }

    public OffHeapRowBlockReader getReader() {
        return new OffHeapRowBlockReader(this);
    }
}

