/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.tuple.offheap.ResizableLimitSpec;
import org.apache.tajo.util.Deallocatable;
import org.apache.tajo.util.FileUtil;
import org.apache.tajo.util.UnsafeUtil;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class OffHeapMemory
implements Deallocatable {
    private static final Log LOG = LogFactory.getLog(OffHeapMemory.class);
    protected static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    protected ByteBuffer buffer;
    protected int memorySize;
    protected ResizableLimitSpec limitSpec;
    protected long address;

    @VisibleForTesting
    protected OffHeapMemory(ByteBuffer buffer, ResizableLimitSpec limitSpec) {
        this.buffer = buffer;
        this.address = ((DirectBuffer)((Object)buffer)).address();
        this.memorySize = buffer.limit();
        this.limitSpec = limitSpec;
    }

    public OffHeapMemory(ResizableLimitSpec limitSpec) {
        this(ByteBuffer.allocateDirect((int)limitSpec.initialSize()).order(ByteOrder.nativeOrder()), limitSpec);
    }

    public long address() {
        return this.address;
    }

    public long size() {
        return this.memorySize;
    }

    public void resize(int newSize) {
        Preconditions.checkArgument((newSize > 0 ? 1 : 0) != 0, (Object)"Size must be greater than 0 bytes");
        if ((long)newSize > this.limitSpec.limit()) {
            throw new RuntimeException("Resize cannot exceed the size limit");
        }
        if (newSize < this.memorySize) {
            LOG.warn((Object)"The size reduction is ignored.");
        }
        int newBlockSize = UnsafeUtil.alignedSize((int)newSize);
        ByteBuffer newByteBuf = ByteBuffer.allocateDirect(newBlockSize);
        long newAddress = ((DirectBuffer)((Object)newByteBuf)).address();
        UNSAFE.copyMemory(this.address, newAddress, this.memorySize);
        UnsafeUtil.free((ByteBuffer)this.buffer);
        this.memorySize = newSize;
        this.buffer = newByteBuf;
        this.address = newAddress;
    }

    public Buffer nioBuffer() {
        return (ByteBuffer)this.buffer.position(0).limit(this.memorySize);
    }

    public void release() {
        UnsafeUtil.free((ByteBuffer)this.buffer);
        this.buffer = null;
        this.address = 0L;
        this.memorySize = 0;
    }

    public String toString() {
        return "memory=" + FileUtil.humanReadableByteCount((long)this.memorySize, (boolean)false) + "," + this.limitSpec;
    }
}

