/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.offheap;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.ProtobufDatumFactory;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.util.StringUtils;
import org.apache.tajo.util.UnsafeUtil;
import sun.misc.Unsafe;

public class HeapTuple
implements Tuple {
    private static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    private static final long BASE_OFFSET = UnsafeUtil.ARRAY_BYTE_BASE_OFFSET;
    private final byte[] data;
    private final TajoDataTypes.DataType[] types;

    public HeapTuple(byte[] bytes, TajoDataTypes.DataType[] types) {
        this.data = bytes;
        this.types = types;
    }

    public int size() {
        return this.data.length;
    }

    public ByteBuffer nioBuffer() {
        return ByteBuffer.wrap(this.data);
    }

    private int getFieldOffset(int fieldId) {
        return UNSAFE.getInt(this.data, BASE_OFFSET + 4L + (long)(fieldId * 4));
    }

    private int checkNullAndGetOffset(int fieldId) {
        int offset = this.getFieldOffset(fieldId);
        if (offset == -1) {
            throw new RuntimeException("Invalid Field Access: " + fieldId);
        }
        return offset;
    }

    public boolean contains(int fieldid) {
        return this.getFieldOffset(fieldid) > -1;
    }

    public boolean isNull(int fieldid) {
        return this.getFieldOffset(fieldid) == -1;
    }

    public boolean isNotNull(int fieldid) {
        return this.getFieldOffset(fieldid) > -1;
    }

    public void clear() {
    }

    public void put(int fieldId, Datum value) {
        throw new UnsupportedException("UnSafeTuple does not support put(int, Datum).");
    }

    public void put(int fieldId, Datum[] values) {
        throw new UnsupportedException("UnSafeTuple does not support put(int, Datum []).");
    }

    public void put(int fieldId, Tuple tuple) {
        throw new UnsupportedException("UnSafeTuple does not support put(int, Tuple).");
    }

    public void put(Datum[] values) {
        throw new UnsupportedException("UnSafeTuple does not support put(Datum []).");
    }

    public Datum get(int fieldId) {
        if (this.isNull(fieldId)) {
            return NullDatum.get();
        }
        switch (this.types[fieldId].getType()) {
            case BOOLEAN: {
                return DatumFactory.createBool((boolean)this.getBool(fieldId));
            }
            case INT1: 
            case INT2: {
                return DatumFactory.createInt2((short)this.getInt2(fieldId));
            }
            case INT4: {
                return DatumFactory.createInt4((int)this.getInt4(fieldId));
            }
            case INT8: {
                return DatumFactory.createInt8((long)this.getInt4(fieldId));
            }
            case FLOAT4: {
                return DatumFactory.createFloat4((float)this.getFloat4(fieldId));
            }
            case FLOAT8: {
                return DatumFactory.createFloat8((double)this.getFloat8(fieldId));
            }
            case TEXT: {
                return DatumFactory.createText((String)this.getText(fieldId));
            }
            case TIMESTAMP: {
                return DatumFactory.createTimestamp((long)this.getInt8(fieldId));
            }
            case DATE: {
                return DatumFactory.createDate((int)this.getInt4(fieldId));
            }
            case TIME: {
                return DatumFactory.createTime((long)this.getInt8(fieldId));
            }
            case INTERVAL: {
                return this.getInterval(fieldId);
            }
            case INET4: {
                return DatumFactory.createInet4((int)this.getInt4(fieldId));
            }
            case PROTOBUF: {
                return this.getProtobufDatum(fieldId);
            }
        }
        throw new UnsupportedException("Unknown type: " + this.types[fieldId]);
    }

    public void setOffset(long offset) {
    }

    public long getOffset() {
        return 0L;
    }

    public boolean getBool(int fieldId) {
        return UNSAFE.getByte(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId)) == 1;
    }

    public byte getByte(int fieldId) {
        return UNSAFE.getByte(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public char getChar(int fieldId) {
        return UNSAFE.getChar(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public byte[] getBytes(int fieldId) {
        long pos = this.checkNullAndGetOffset(fieldId);
        int len = UNSAFE.getInt(this.data, BASE_OFFSET + pos);
        byte[] bytes = new byte[len];
        UNSAFE.copyMemory(this.data, BASE_OFFSET + (pos += 4L), bytes, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, len);
        return bytes;
    }

    public short getInt2(int fieldId) {
        return UNSAFE.getShort(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public int getInt4(int fieldId) {
        return UNSAFE.getInt(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public long getInt8(int fieldId) {
        return UNSAFE.getLong(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public float getFloat4(int fieldId) {
        return UNSAFE.getFloat(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public double getFloat8(int fieldId) {
        return UNSAFE.getDouble(this.data, BASE_OFFSET + (long)this.checkNullAndGetOffset(fieldId));
    }

    public String getText(int fieldId) {
        return new String(this.getBytes(fieldId));
    }

    public IntervalDatum getInterval(int fieldId) {
        long pos = this.checkNullAndGetOffset(fieldId);
        int months = UNSAFE.getInt(this.data, BASE_OFFSET + pos);
        long millisecs = UNSAFE.getLong(this.data, BASE_OFFSET + (pos += 4L));
        return new IntervalDatum(months, millisecs);
    }

    public Datum getProtobufDatum(int fieldId) {
        byte[] bytes = this.getBytes(fieldId);
        ProtobufDatumFactory factory = ProtobufDatumFactory.get((String)this.types[fieldId].getCode());
        Message.Builder builder = factory.newBuilder();
        try {
            builder.mergeFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            return NullDatum.get();
        }
        return new ProtobufDatum(builder.build());
    }

    public char[] getUnicodeChars(int fieldId) {
        long pos = this.checkNullAndGetOffset(fieldId);
        int len = UNSAFE.getInt(this.data, BASE_OFFSET + pos);
        byte[] bytes = new byte[len];
        UNSAFE.copyMemory(this.data, BASE_OFFSET + (pos += 4L), bytes, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET, len);
        return StringUtils.convertBytesToChars((byte[])bytes, (Charset)Charset.forName("UTF-8"));
    }

    public Tuple clone() throws CloneNotSupportedException {
        return this;
    }

    public Datum[] getValues() {
        Datum[] datums = new Datum[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            datums[i] = this.contains(i) ? this.get(i) : NullDatum.get();
        }
        return datums;
    }

    public String toString() {
        return VTuple.toDisplayString((Datum[])this.getValues());
    }
}

