/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.TupleBuilder;
import org.apache.tajo.tuple.offheap.HeapTuple;
import org.apache.tajo.tuple.offheap.OffHeapRowWriter;
import org.apache.tajo.tuple.offheap.ZeroCopyTuple;
import org.apache.tajo.util.Deallocatable;
import org.apache.tajo.util.FileUtil;
import org.apache.tajo.util.UnsafeUtil;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class BaseTupleBuilder
extends OffHeapRowWriter
implements TupleBuilder,
Deallocatable {
    private static final Log LOG = LogFactory.getLog(BaseTupleBuilder.class);
    private static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    private ByteBuffer buffer = ByteBuffer.allocateDirect(65536).order(ByteOrder.nativeOrder());
    private long address = UnsafeUtil.getAddress((ByteBuffer)this.buffer);

    public BaseTupleBuilder(Schema schema) {
        super(SchemaUtil.toDataTypes((Schema)schema));
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public void ensureSize(int size) {
        if (this.buffer.remaining() - size < 0) {
            int newBlockSize = UnsafeUtil.alignedSize((int)(this.buffer.capacity() * 2));
            ByteBuffer newByteBuf = ByteBuffer.allocateDirect(newBlockSize);
            long newAddress = ((DirectBuffer)((Object)newByteBuf)).address();
            UNSAFE.copyMemory(this.address, newAddress, this.buffer.limit());
            LOG.debug((Object)("Increase the buffer size to " + FileUtil.humanReadableByteCount((long)newBlockSize, (boolean)false)));
            UnsafeUtil.free((ByteBuffer)this.buffer);
            this.buffer = newByteBuf;
            this.address = newAddress;
        }
    }

    @Override
    public int position() {
        return 0;
    }

    @Override
    public void forward(int length) {
    }

    @Override
    public void endRow() {
        super.endRow();
        this.buffer.position(0).limit(this.offset());
    }

    @Override
    public Tuple build() {
        return this.buildToHeapTuple();
    }

    public HeapTuple buildToHeapTuple() {
        byte[] bytes = new byte[this.buffer.limit()];
        UNSAFE.copyMemory(null, this.address, bytes, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET, this.buffer.limit());
        return new HeapTuple(bytes, this.dataTypes());
    }

    public ZeroCopyTuple buildToZeroCopyTuple() {
        ZeroCopyTuple zcTuple = new ZeroCopyTuple();
        zcTuple.set(this.buffer, 0, this.buffer.limit(), this.dataTypes());
        return zcTuple;
    }

    public void release() {
        UnsafeUtil.free((ByteBuffer)this.buffer);
        this.buffer = null;
        this.address = 0L;
    }
}

