/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage.fragment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tajo.annotation.ThreadSafe;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.storage.fragment.Fragment;

@ThreadSafe
public class FragmentConvertor {
    protected static final Map<String, Class<? extends Fragment>> CACHED_FRAGMENT_CLASSES = Maps.newConcurrentMap();
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = Maps.newConcurrentMap();
    private static final Class<?>[] DEFAULT_FRAGMENT_PARAMS = new Class[]{ByteString.class};

    public static Class<? extends Fragment> getFragmentClass(Configuration conf, String storeType) throws IOException {
        Class fragmentClass = CACHED_FRAGMENT_CLASSES.get(storeType.toLowerCase());
        if (fragmentClass == null) {
            fragmentClass = conf.getClass(String.format("tajo.storage.fragment.%s.class", storeType.toLowerCase()), null, Fragment.class);
            CACHED_FRAGMENT_CLASSES.put(storeType.toLowerCase(), fragmentClass);
        }
        if (fragmentClass == null) {
            throw new IOException("No such a fragment for " + storeType.toLowerCase());
        }
        return fragmentClass;
    }

    public static <T extends Fragment> T convert(Class<T> clazz, CatalogProtos.FragmentProto fragment) {
        Fragment result;
        try {
            Constructor<Object> constructor = CONSTRUCTOR_CACHE.get(clazz);
            if (constructor == null) {
                constructor = clazz.getDeclaredConstructor(DEFAULT_FRAGMENT_PARAMS);
                constructor.setAccessible(true);
                CONSTRUCTOR_CACHE.put(clazz, constructor);
            }
            result = (Fragment)constructor.newInstance(fragment.getContents());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T extends Fragment> T convert(Configuration conf, CatalogProtos.FragmentProto fragment) throws IOException {
        Class<? extends Fragment> fragmentClass = FragmentConvertor.getFragmentClass(conf, fragment.getStoreType().toLowerCase());
        if (fragmentClass == null) {
            throw new IOException("No such a fragment class for " + fragment.getStoreType());
        }
        return (T)FragmentConvertor.convert(fragmentClass, fragment);
    }

    public static <T extends Fragment> List<T> convert(Class<T> clazz, CatalogProtos.FragmentProto ... fragments) throws IOException {
        ArrayList list = Lists.newArrayList();
        if (fragments == null) {
            return list;
        }
        for (CatalogProtos.FragmentProto proto : fragments) {
            list.add(FragmentConvertor.convert(clazz, proto));
        }
        return list;
    }

    public static <T extends Fragment> List<T> convert(Configuration conf, CatalogProtos.FragmentProto ... fragments) throws IOException {
        ArrayList list = Lists.newArrayList();
        if (fragments == null) {
            return list;
        }
        for (CatalogProtos.FragmentProto proto : fragments) {
            list.add(FragmentConvertor.convert(conf, proto));
        }
        return list;
    }

    public static List<CatalogProtos.FragmentProto> toFragmentProtoList(Fragment ... fragments) {
        ArrayList list = Lists.newArrayList();
        if (fragments == null) {
            return list;
        }
        for (Fragment fragment : fragments) {
            list.add(fragment.getProto());
        }
        return list;
    }

    public static CatalogProtos.FragmentProto[] toFragmentProtoArray(Fragment ... fragments) {
        List<CatalogProtos.FragmentProto> list = FragmentConvertor.toFragmentProtoList(fragments);
        return list.toArray(new CatalogProtos.FragmentProto[list.size()]);
    }
}

