/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.common.base.Objects;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.storage.BaseTupleComparator;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.TupleComparator;

public class TupleRange
implements Comparable<TupleRange>,
Cloneable {
    private Tuple start;
    private Tuple end;
    private final TupleComparator comp;

    public TupleRange(SortSpec[] sortSpecs, Tuple start, Tuple end) {
        this.comp = new BaseTupleComparator(TupleRange.sortSpecsToSchema(sortSpecs), sortSpecs);
        this.start = start;
        this.end = end;
    }

    public static Schema sortSpecsToSchema(SortSpec[] sortSpecs) {
        Schema schema = new Schema();
        for (SortSpec spec : sortSpecs) {
            schema.addColumn(spec.getSortKey());
        }
        return schema;
    }

    public void setStart(Tuple tuple) {
        this.start = tuple;
    }

    public final Tuple getStart() {
        return this.start;
    }

    public void setEnd(Tuple tuple) {
        this.end = tuple;
    }

    public final Tuple getEnd() {
        return this.end;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ")";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleRange) {
            TupleRange other = (TupleRange)obj;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    @Override
    public int compareTo(TupleRange o) {
        int cmpVal = this.comp.compare(this.start, o.start);
        if (cmpVal != 0) {
            return cmpVal;
        }
        return this.comp.compare(this.end, o.end);
    }

    public TupleRange clone() throws CloneNotSupportedException {
        TupleRange newRange = (TupleRange)super.clone();
        newRange.setStart(this.start.clone());
        newRange.setEnd(this.end.clone());
        return newRange;
    }
}

