/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.ProtobufDatumFactory;
import org.apache.tajo.datum.TimeDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.datum.protobuf.ProtobufJsonFormat;
import org.apache.tajo.storage.SerializerDeserializer;
import org.apache.tajo.util.Bytes;
import org.apache.tajo.util.NumberUtil;

@Deprecated
public class TextSerializerDeserializer
implements SerializerDeserializer {
    public static final byte[] trueBytes = "true".getBytes();
    public static final byte[] falseBytes = "false".getBytes();
    private ProtobufJsonFormat protobufJsonFormat = ProtobufJsonFormat.getInstance();

    @Override
    public int serialize(Column col, Datum datum, OutputStream out, byte[] nullCharacters) throws IOException {
        int length = 0;
        TajoDataTypes.DataType dataType = col.getDataType();
        if (datum == null || datum instanceof NullDatum) {
            switch (dataType.getType()) {
                case CHAR: 
                case TEXT: {
                    length = nullCharacters.length;
                    out.write(nullCharacters);
                    break;
                }
            }
            return length;
        }
        switch (dataType.getType()) {
            case BOOLEAN: {
                out.write(datum.asBool() ? trueBytes : falseBytes);
                length = trueBytes.length;
                break;
            }
            case CHAR: {
                byte[] pad = new byte[dataType.getLength() - datum.size()];
                byte[] bytes = datum.asTextBytes();
                out.write(bytes);
                out.write(pad);
                length = bytes.length + pad.length;
                break;
            }
            case TEXT: 
            case BIT: 
            case INT2: 
            case INT4: 
            case INT8: 
            case FLOAT4: 
            case FLOAT8: 
            case INET4: 
            case DATE: 
            case INTERVAL: {
                byte[] bytes = datum.asTextBytes();
                length = bytes.length;
                out.write(bytes);
                break;
            }
            case TIME: {
                byte[] bytes = ((TimeDatum)datum).asChars(TimeZone.getDefault(), true).getBytes();
                length = bytes.length;
                out.write(bytes);
                break;
            }
            case TIMESTAMP: {
                byte[] bytes = ((TimestampDatum)datum).asChars(TimeZone.getDefault(), true).getBytes();
                length = bytes.length;
                out.write(bytes);
                break;
            }
            case INET6: 
            case BLOB: {
                byte[] bytes = Base64.encodeBase64((byte[])datum.asByteArray(), (boolean)false);
                length = bytes.length;
                out.write(bytes, 0, length);
                break;
            }
            case PROTOBUF: {
                ProtobufDatum protobuf = (ProtobufDatum)datum;
                byte[] protoBytes = this.protobufJsonFormat.printToString(protobuf.get()).getBytes();
                length = protoBytes.length;
                out.write(protoBytes, 0, protoBytes.length);
                break;
            }
        }
        return length;
    }

    @Override
    public Datum deserialize(Column col, byte[] bytes, int offset, int length, byte[] nullCharacters) throws IOException {
        NullDatum datum;
        switch (col.getDataType().getType()) {
            case BOOLEAN: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createBool((bytes[offset] == 116 || bytes[offset] == 84 ? 1 : 0) != 0);
                break;
            }
            case BIT: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createBit((byte)Byte.parseByte(new String(bytes, offset, length)));
                break;
            }
            case CHAR: {
                datum = TextSerializerDeserializer.isNullText(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createChar((String)new String(bytes, offset, length).trim());
                break;
            }
            case INT2: 
            case INT1: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createInt2((short)((short)NumberUtil.parseInt((byte[])bytes, (int)offset, (int)length)));
                break;
            }
            case INT4: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createInt4((int)NumberUtil.parseInt((byte[])bytes, (int)offset, (int)length));
                break;
            }
            case INT8: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createInt8((String)new String(bytes, offset, length));
                break;
            }
            case FLOAT4: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createFloat4((String)new String(bytes, offset, length));
                break;
            }
            case FLOAT8: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createFloat8((double)NumberUtil.parseDouble((byte[])bytes, (int)offset, (int)length));
                break;
            }
            case TEXT: {
                byte[] chars = new byte[length];
                System.arraycopy(bytes, offset, chars, 0, length);
                datum = TextSerializerDeserializer.isNullText(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createText((byte[])chars);
                break;
            }
            case DATE: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createDate((String)new String(bytes, offset, length));
                break;
            }
            case TIME: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createTime((String)new String(bytes, offset, length));
                break;
            }
            case TIMESTAMP: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createTimestamp((String)new String(bytes, offset, length));
                break;
            }
            case INTERVAL: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createInterval((String)new String(bytes, offset, length));
                break;
            }
            case PROTOBUF: {
                if (TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters)) {
                    datum = NullDatum.get();
                    break;
                }
                ProtobufDatumFactory factory = ProtobufDatumFactory.get((TajoDataTypes.DataType)col.getDataType());
                Message.Builder builder = factory.newBuilder();
                try {
                    byte[] protoBytes = new byte[length];
                    System.arraycopy(bytes, offset, protoBytes, 0, length);
                    this.protobufJsonFormat.merge(protoBytes, builder);
                    datum = factory.createDatum(builder.build());
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            case INET4: {
                datum = TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters) ? NullDatum.get() : DatumFactory.createInet4((String)new String(bytes, offset, length));
                break;
            }
            case BLOB: {
                if (TextSerializerDeserializer.isNull(bytes, offset, length, nullCharacters)) {
                    datum = NullDatum.get();
                    break;
                }
                byte[] blob = new byte[length];
                System.arraycopy(bytes, offset, blob, 0, length);
                datum = DatumFactory.createBlob((byte[])Base64.decodeBase64((byte[])blob));
                break;
            }
            default: {
                datum = NullDatum.get();
            }
        }
        return datum;
    }

    private static boolean isNull(byte[] val, int offset, int length, byte[] nullBytes) {
        return length == 0 || length == nullBytes.length && Bytes.equals((byte[])val, (int)offset, (int)length, (byte[])nullBytes, (int)0, (int)nullBytes.length);
    }

    private static boolean isNullText(byte[] val, int offset, int length, byte[] nullBytes) {
        return length > 0 && length == nullBytes.length && Bytes.equals((byte[])val, (int)offset, (int)length, (byte[])nullBytes, (int)0, (int)nullBytes.length);
    }
}

