/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.statistics.ColumnStats;
import org.apache.tajo.catalog.statistics.TableStats;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;

public class TableStatistics {
    private static final Log LOG = LogFactory.getLog(TableStatistics.class);
    private Schema schema;
    private Tuple minValues;
    private Tuple maxValues;
    private long[] numNulls;
    private long numRows = 0L;
    private long numBytes = 0L;
    private boolean[] comparable;

    public TableStatistics(Schema schema) {
        this.schema = schema;
        this.minValues = new VTuple(schema.size());
        this.maxValues = new VTuple(schema.size());
        this.numNulls = new long[schema.size()];
        this.comparable = new boolean[schema.size()];
        for (int i = 0; i < schema.size(); ++i) {
            TajoDataTypes.DataType type = schema.getColumn(i).getDataType();
            this.comparable[i] = type.getType() != TajoDataTypes.Type.PROTOBUF;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void incrementRow() {
        ++this.numRows;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public void setNumBytes(long bytes) {
        this.numBytes = bytes;
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public void analyzeField(int idx, Datum datum) {
        if (datum instanceof NullDatum) {
            int n = idx;
            this.numNulls[n] = this.numNulls[n] + 1L;
            return;
        }
        if (this.comparable[idx]) {
            if (!this.maxValues.contains(idx) || this.maxValues.get(idx).compareTo(datum) < 0) {
                this.maxValues.put(idx, datum);
            }
            if (!this.minValues.contains(idx) || this.minValues.get(idx).compareTo(datum) > 0) {
                this.minValues.put(idx, datum);
            }
        }
    }

    public TableStats getTableStat() {
        TableStats stat = new TableStats();
        for (int i = 0; i < this.schema.size(); ++i) {
            ColumnStats columnStats = new ColumnStats(this.schema.getColumn(i));
            columnStats.setNumNulls(this.numNulls[i]);
            if (this.minValues.get(i) == null || this.schema.getColumn(i).getDataType().getType() == this.minValues.get(i).type()) {
                columnStats.setMinValue(this.minValues.get(i));
            } else {
                LOG.warn((Object)("Wrong statistics column type (" + this.minValues.get(i).type() + ", expected=" + this.schema.getColumn(i).getDataType().getType() + ")"));
            }
            if (this.maxValues.get(i) == null || this.schema.getColumn(i).getDataType().getType() == this.maxValues.get(i).type()) {
                columnStats.setMaxValue(this.maxValues.get(i));
            } else {
                LOG.warn((Object)("Wrong statistics column type (" + this.maxValues.get(i).type() + ", expected=" + this.schema.getColumn(i).getDataType().getType() + ")"));
            }
            stat.addColumnStat(columnStats);
        }
        stat.setNumRows(this.numRows);
        stat.setNumBytes(this.numBytes);
        return stat;
    }
}

