/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.storage.StorageConstants;
import sun.nio.ch.DirectBuffer;

public class StorageUtil
extends StorageConstants {
    static final String fileNamePatternV08 = "part-[0-9]*-[0-9]*";
    static final String fileNamePatternV09 = "part-[0-9]*-[0-9]*-[0-9]*";

    public static int getColByteSize(Column col) {
        switch (col.getDataType().getType()) {
            case BOOLEAN: {
                return 1;
            }
            case CHAR: {
                return 1;
            }
            case BIT: {
                return 1;
            }
            case INT2: {
                return 2;
            }
            case INT4: {
                return 4;
            }
            case INT8: {
                return 8;
            }
            case FLOAT4: {
                return 4;
            }
            case FLOAT8: {
                return 8;
            }
            case INET4: {
                return 4;
            }
            case INET6: {
                return 32;
            }
            case TEXT: {
                return 256;
            }
            case BLOB: {
                return 256;
            }
            case DATE: {
                return 4;
            }
            case TIME: {
                return 8;
            }
            case TIMESTAMP: {
                return 8;
            }
        }
        return 0;
    }

    public static Path concatPath(String parent, String ... childs) {
        return StorageUtil.concatPath(new Path(parent), childs);
    }

    public static Path concatPath(Path parent, String ... childs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childs.length; ++i) {
            sb.append(childs[i]);
            if (i >= childs.length - 1) continue;
            sb.append("/");
        }
        return new Path(parent, sb.toString());
    }

    public static int getMaxFileSequence(FileSystem fs, Path path, boolean recursive) throws IOException {
        if (!fs.isDirectory(path)) {
            return -1;
        }
        FileStatus[] files = fs.listStatus(path);
        if (files == null || files.length == 0) {
            return -1;
        }
        int maxValue = -1;
        ArrayList<Path> fileNamePatternMatchedList = new ArrayList<Path>();
        for (FileStatus eachFile : files) {
            if (eachFile.isDirectory() && recursive) {
                int value = StorageUtil.getMaxFileSequence(fs, eachFile.getPath(), recursive);
                if (value <= maxValue) continue;
                maxValue = value;
                continue;
            }
            if (!eachFile.getPath().getName().matches(fileNamePatternV08) && !eachFile.getPath().getName().matches(fileNamePatternV09)) continue;
            fileNamePatternMatchedList.add(eachFile.getPath());
        }
        if (fileNamePatternMatchedList.isEmpty()) {
            return maxValue;
        }
        Path lastFile = (Path)fileNamePatternMatchedList.get(fileNamePatternMatchedList.size() - 1);
        String pathName = lastFile.getName();
        String[] pathTokens = pathName.split("-");
        if (pathTokens.length == 3) {
            return -1;
        }
        if (pathTokens.length == 4) {
            return Integer.parseInt(pathTokens[3]);
        }
        return -1;
    }

    public static void closeBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            if (buffer.isDirect()) {
                ((DirectBuffer)((Object)buffer)).cleaner().clean();
            } else {
                buffer.clear();
            }
        }
    }

    public static int readFully(InputStream is, byte[] buffer, int offset, int length) throws IOException {
        int nread;
        int nbytes;
        for (nread = 0; nread < length; nread += nbytes) {
            nbytes = is.read(buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            return nread > 0 ? nread : nbytes;
        }
        return nread;
    }

    public static void skipFully(DataInput in, int len) throws IOException {
        int amt = len;
        while (amt > 0) {
            long ret = in.skipBytes(amt);
            if (ret == 0L) {
                byte b = in.readByte();
                if (b == -1) {
                    throw new EOFException("Premature EOF from inputStream after skipping " + (len - amt) + " byte(s).");
                }
                ret = 1L;
            }
            amt = (int)((long)amt - ret);
        }
    }
}

