/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.ExecutionBlockId;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.QueryVars;
import org.apache.tajo.TaskAttemptId;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteRule;
import org.apache.tajo.storage.Appender;
import org.apache.tajo.storage.NullScanner;
import org.apache.tajo.storage.Scanner;
import org.apache.tajo.storage.SeekableScanner;
import org.apache.tajo.storage.StorageProperty;
import org.apache.tajo.storage.StorageUtil;
import org.apache.tajo.storage.TupleRange;
import org.apache.tajo.storage.fragment.Fragment;
import org.apache.tajo.storage.fragment.FragmentConvertor;
import org.apache.tajo.util.TUtil;

public abstract class StorageManager {
    private final Log LOG = LogFactory.getLog(StorageManager.class);
    private static final Class<?>[] DEFAULT_SCANNER_PARAMS = new Class[]{Configuration.class, Schema.class, TableMeta.class, Fragment.class};
    private static final Class<?>[] DEFAULT_APPENDER_PARAMS = new Class[]{Configuration.class, TaskAttemptId.class, Schema.class, TableMeta.class, Path.class};
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    protected TajoConf conf;
    protected CatalogProtos.StoreType storeType;
    private static final Map<String, StorageManager> storageManagers = Maps.newHashMap();
    protected static final Map<String, Class<? extends Scanner>> SCANNER_HANDLER_CACHE = new ConcurrentHashMap<String, Class<? extends Scanner>>();
    protected static final Map<String, Class<? extends Appender>> APPENDER_HANDLER_CACHE = new ConcurrentHashMap<String, Class<? extends Appender>>();
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();

    public StorageManager(CatalogProtos.StoreType storeType) {
        this.storeType = storeType;
    }

    protected abstract void storageInit() throws IOException;

    public abstract void createTable(TableDesc var1, boolean var2) throws IOException;

    public abstract void purgeTable(TableDesc var1) throws IOException;

    public abstract List<Fragment> getSplits(String var1, TableDesc var2, ScanNode var3) throws IOException;

    public abstract List<Fragment> getNonForwardSplit(TableDesc var1, int var2, int var3) throws IOException;

    public abstract StorageProperty getStorageProperty();

    public abstract void closeStorageManager();

    @VisibleForTesting
    protected static synchronized void clearCache() {
        CONSTRUCTOR_CACHE.clear();
        SCANNER_HANDLER_CACHE.clear();
        APPENDER_HANDLER_CACHE.clear();
        storageManagers.clear();
    }

    public abstract TupleRange[] getInsertSortRanges(OverridableConf var1, TableDesc var2, Schema var3, SortSpec[] var4, TupleRange var5) throws IOException;

    public abstract void beforeInsertOrCATS(LogicalNode var1) throws IOException;

    public abstract void rollbackOutputCommit(LogicalNode var1) throws IOException;

    public CatalogProtos.StoreType getStoreType() {
        return this.storeType;
    }

    public void init(TajoConf tajoConf) throws IOException {
        this.conf = tajoConf;
        this.storageInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() throws IOException {
        Map<String, StorageManager> map = storageManagers;
        synchronized (map) {
            for (StorageManager eachStorageManager : storageManagers.values()) {
                eachStorageManager.closeStorageManager();
            }
        }
        StorageManager.clearCache();
    }

    public List<Fragment> getSplits(String fragmentId, TableDesc tableDesc) throws IOException {
        return this.getSplits(fragmentId, tableDesc, null);
    }

    public static StorageManager getFileStorageManager(TajoConf tajoConf) throws IOException {
        return StorageManager.getStorageManager(tajoConf, CatalogProtos.StoreType.CSV);
    }

    public static StorageManager getStorageManager(TajoConf tajoConf, String storeType) throws IOException {
        if ("HBASE".equalsIgnoreCase(storeType)) {
            return StorageManager.getStorageManager(tajoConf, CatalogProtos.StoreType.HBASE);
        }
        return StorageManager.getStorageManager(tajoConf, CatalogProtos.StoreType.CSV);
    }

    public static StorageManager getStorageManager(TajoConf tajoConf, CatalogProtos.StoreType storeType) throws IOException {
        FileSystem fileSystem = TajoConf.getWarehouseDir((TajoConf)tajoConf).getFileSystem((Configuration)tajoConf);
        if (fileSystem != null) {
            return StorageManager.getStorageManager(tajoConf, storeType, fileSystem.getUri().toString());
        }
        return StorageManager.getStorageManager(tajoConf, storeType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized StorageManager getStorageManager(TajoConf tajoConf, CatalogProtos.StoreType storeType, String managerKey) throws IOException {
        String typeName;
        switch (storeType) {
            case HBASE: {
                typeName = "hbase";
                break;
            }
            default: {
                typeName = "hdfs";
            }
        }
        Map<String, StorageManager> map = storageManagers;
        synchronized (map) {
            String storeKey = typeName + "_" + managerKey;
            StorageManager manager = storageManagers.get(storeKey);
            if (manager == null) {
                Class storageManagerClass = tajoConf.getClass(String.format("tajo.storage.manager.%s.class", typeName), null, StorageManager.class);
                if (storageManagerClass == null) {
                    throw new IOException("Unknown Storage Type: " + typeName);
                }
                try {
                    Constructor<Object> constructor = CONSTRUCTOR_CACHE.get(storageManagerClass);
                    if (constructor == null) {
                        constructor = storageManagerClass.getDeclaredConstructor(CatalogProtos.StoreType.class);
                        constructor.setAccessible(true);
                        CONSTRUCTOR_CACHE.put(storageManagerClass, constructor);
                    }
                    manager = (StorageManager)constructor.newInstance(storeType);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                manager.init(tajoConf);
                storageManagers.put(storeKey, manager);
            }
            return manager;
        }
    }

    public Scanner getScanner(TableMeta meta, Schema schema, CatalogProtos.FragmentProto fragment, Schema target) throws IOException {
        return this.getScanner(meta, schema, (Fragment)FragmentConvertor.convert((Configuration)this.conf, fragment), target);
    }

    public Scanner getScanner(TableMeta meta, Schema schema, Fragment fragment) throws IOException {
        return this.getScanner(meta, schema, fragment, schema);
    }

    public Scanner getScanner(TableMeta meta, Schema schema, Fragment fragment, Schema target) throws IOException {
        if (fragment.isEmpty()) {
            NullScanner scanner = new NullScanner((Configuration)this.conf, schema, meta, fragment);
            scanner.setTarget(target.toArray());
            return scanner;
        }
        Class<? extends Scanner> scannerClass = this.getScannerClass(meta.getStoreType());
        Scanner scanner = StorageManager.newScannerInstance(scannerClass, (Configuration)this.conf, schema, meta, fragment);
        if (scanner.isProjectable()) {
            scanner.setTarget(target.toArray());
        }
        return scanner;
    }

    public static synchronized SeekableScanner getSeekableScanner(TajoConf conf, TableMeta meta, Schema schema, Fragment fragment, Schema target) throws IOException {
        return (SeekableScanner)StorageManager.getStorageManager(conf, meta.getStoreType()).getScanner(meta, schema, fragment, target);
    }

    public Appender getAppender(OverridableConf queryContext, TaskAttemptId taskAttemptId, TableMeta meta, Schema schema, Path workDir) throws IOException {
        String handlerName = CatalogUtil.getStoreTypeString((CatalogProtos.StoreType)meta.getStoreType()).toLowerCase();
        Class appenderClass = APPENDER_HANDLER_CACHE.get(handlerName);
        if (appenderClass == null) {
            appenderClass = this.conf.getClass(String.format("tajo.storage.appender-handler.%s.class", handlerName), null, Appender.class);
            APPENDER_HANDLER_CACHE.put(handlerName, appenderClass);
        }
        if (appenderClass == null) {
            throw new IOException("Unknown Storage Type: " + meta.getStoreType());
        }
        Appender appender = StorageManager.newAppenderInstance(appenderClass, (Configuration)this.conf, taskAttemptId, meta, schema, workDir);
        return appender;
    }

    public static <T> T newScannerInstance(Class<T> theClass, Configuration conf, Schema schema, TableMeta meta, Fragment fragment) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(DEFAULT_SCANNER_PARAMS);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(conf, schema, meta, fragment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T newAppenderInstance(Class<T> theClass, Configuration conf, TaskAttemptId taskAttemptId, TableMeta meta, Schema schema, Path workDir) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(DEFAULT_APPENDER_PARAMS);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(conf, taskAttemptId, schema, meta, workDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public Class<? extends Scanner> getScannerClass(CatalogProtos.StoreType storeType) throws IOException {
        String handlerName = CatalogUtil.getStoreTypeString((CatalogProtos.StoreType)storeType).toLowerCase();
        Class scannerClass = SCANNER_HANDLER_CACHE.get(handlerName);
        if (scannerClass == null) {
            scannerClass = this.conf.getClass(String.format("tajo.storage.scanner-handler.%s.class", handlerName), null, Scanner.class);
            SCANNER_HANDLER_CACHE.put(handlerName, scannerClass);
        }
        if (scannerClass == null) {
            throw new IOException("Unknown Storage Type: " + storeType.name());
        }
        return scannerClass;
    }

    public static long getFragmentLength(TajoConf conf, Fragment fragment) {
        if (fragment.getLength() == -1L) {
            return conf.getLongVar(TajoConf.ConfVars.FRAGMENT_ALTERNATIVE_UNKNOWN_LENGTH);
        }
        return fragment.getLength();
    }

    public void verifyInsertTableSchema(TableDesc tableDesc, Schema outSchema) throws IOException {
    }

    public List<LogicalPlanRewriteRule> getRewriteRules(OverridableConf queryContext, TableDesc tableDesc) throws IOException {
        return null;
    }

    public Path commitOutputData(OverridableConf queryContext, ExecutionBlockId finalEbId, LogicalPlan plan, Schema schema, TableDesc tableDesc) throws IOException {
        return this.commitOutputData(queryContext, finalEbId, plan, schema, tableDesc, true);
    }

    protected Path commitOutputData(OverridableConf queryContext, ExecutionBlockId finalEbId, LogicalPlan plan, Schema schema, TableDesc tableDesc, boolean changeFileSeq) throws IOException {
        Path finalOutputDir;
        Path stagingDir = new Path(queryContext.get((ConfigKey)QueryVars.STAGING_DIR));
        Path stagingResultDir = new Path(stagingDir, "RESULT");
        if (!queryContext.get((ConfigKey)QueryVars.OUTPUT_TABLE_PATH, "").isEmpty()) {
            finalOutputDir = new Path(queryContext.get((ConfigKey)QueryVars.OUTPUT_TABLE_PATH));
            try {
                FileSystem fs = stagingResultDir.getFileSystem((Configuration)this.conf);
                if (queryContext.getBool((ConfigKey)QueryVars.OUTPUT_OVERWRITE, Boolean.valueOf(false))) {
                    boolean movedToOldTable = false;
                    boolean committed = false;
                    Path oldTableDir = new Path(stagingDir, "OLD_TABLE");
                    ContentSummary summary = fs.getContentSummary(stagingResultDir);
                    if (!queryContext.get((ConfigKey)QueryVars.OUTPUT_PARTITIONS, "").isEmpty() && summary.getFileCount() > 0L) {
                        Map renameDirs = TUtil.newHashMap();
                        Map recoveryDirs = TUtil.newHashMap();
                        try {
                            if (!fs.exists(finalOutputDir)) {
                                fs.mkdirs(finalOutputDir);
                            }
                            this.visitPartitionedDirectory(fs, stagingResultDir, finalOutputDir, stagingResultDir.toString(), renameDirs, oldTableDir);
                            for (Map.Entry entry : renameDirs.entrySet()) {
                                if (fs.exists((Path)entry.getValue())) {
                                    String recoveryPathString = ((Path)entry.getValue()).toString().replaceAll(finalOutputDir.toString(), oldTableDir.toString());
                                    Path recoveryPath = new Path(recoveryPathString);
                                    fs.rename((Path)entry.getValue(), recoveryPath);
                                    fs.exists(recoveryPath);
                                    recoveryDirs.put(entry.getValue(), recoveryPath);
                                }
                                fs.delete((Path)entry.getValue(), true);
                                fs.rename((Path)entry.getKey(), (Path)entry.getValue());
                            }
                        }
                        catch (IOException ioe) {
                            for (Map.Entry entry : renameDirs.entrySet()) {
                                fs.delete((Path)entry.getValue(), true);
                            }
                            for (Map.Entry entry : recoveryDirs.entrySet()) {
                                fs.delete((Path)entry.getValue(), true);
                                fs.rename((Path)entry.getValue(), (Path)entry.getKey());
                            }
                            throw new IOException(ioe.getMessage());
                        }
                    } else {
                        try {
                            if (fs.exists(finalOutputDir)) {
                                fs.mkdirs(oldTableDir);
                                for (FileStatus status : fs.listStatus(finalOutputDir, hiddenFileFilter)) {
                                    fs.rename(status.getPath(), oldTableDir);
                                }
                                movedToOldTable = fs.exists(oldTableDir);
                            } else {
                                fs.mkdirs(finalOutputDir);
                            }
                            for (FileStatus status : fs.listStatus(stagingResultDir)) {
                                fs.rename(status.getPath(), finalOutputDir);
                            }
                            committed = fs.exists(finalOutputDir);
                        }
                        catch (IOException ioe) {
                            if (movedToOldTable && !committed) {
                                for (FileStatus status : fs.listStatus(finalOutputDir, hiddenFileFilter)) {
                                    fs.delete(status.getPath(), true);
                                }
                                for (FileStatus status : fs.listStatus(oldTableDir)) {
                                    fs.rename(status.getPath(), finalOutputDir);
                                }
                            }
                            throw new IOException(ioe.getMessage());
                        }
                    }
                } else {
                    String queryType = queryContext.get((ConfigKey)QueryVars.COMMAND_TYPE);
                    if (queryType != null && queryType.equals(NodeType.INSERT.name())) {
                        NumberFormat fmt = NumberFormat.getInstance();
                        fmt.setGroupingUsed(false);
                        fmt.setMinimumIntegerDigits(3);
                        if (!queryContext.get((ConfigKey)QueryVars.OUTPUT_PARTITIONS, "").isEmpty()) {
                            for (FileStatus eachFile : fs.listStatus(stagingResultDir)) {
                                if (eachFile.isFile()) {
                                    this.LOG.warn((Object)("Partition table can't have file in a staging dir: " + eachFile.getPath()));
                                    continue;
                                }
                                this.moveResultFromStageToFinal(fs, stagingResultDir, eachFile, finalOutputDir, fmt, -1, changeFileSeq);
                            }
                        } else {
                            int maxSeq = StorageUtil.getMaxFileSequence(fs, finalOutputDir, false) + 1;
                            for (FileStatus eachFile : fs.listStatus(stagingResultDir)) {
                                if (eachFile.getPath().getName().startsWith("_")) continue;
                                this.moveResultFromStageToFinal(fs, stagingResultDir, eachFile, finalOutputDir, fmt, maxSeq++, changeFileSeq);
                            }
                        }
                        this.verifyAllFileMoved(fs, stagingResultDir);
                        FileStatus[] files = fs.listStatus(stagingResultDir);
                        if (files != null && files.length != 0) {
                            for (FileStatus eachFile : files) {
                                this.LOG.error((Object)("There are some unmoved files in staging dir:" + eachFile.getPath()));
                            }
                        }
                    } else {
                        if (fs.exists(finalOutputDir)) {
                            for (FileStatus status : fs.listStatus(stagingResultDir)) {
                                fs.rename(status.getPath(), finalOutputDir);
                            }
                        } else {
                            fs.rename(stagingResultDir, finalOutputDir);
                        }
                        this.LOG.info((Object)("Moved from the staging dir to the output directory '" + finalOutputDir));
                    }
                }
                Path stagingDirRoot = stagingDir.getParent();
                fs.delete(stagingDirRoot, true);
            }
            catch (Throwable t) {
                this.LOG.error((Object)t);
                throw new IOException(t);
            }
        }
        finalOutputDir = new Path(stagingDir, "RESULT");
        return finalOutputDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveResultFromStageToFinal(FileSystem fs, Path stagingResultDir, FileStatus fileStatus, Path finalOutputPath, NumberFormat nf, int fileSeq, boolean changeFileSeq) throws IOException {
        if (fileStatus.isDirectory()) {
            String subPath = this.extractSubPath(stagingResultDir, fileStatus.getPath());
            if (subPath == null) throw new IOException("Wrong staging dir:" + stagingResultDir + "," + fileStatus.getPath());
            Path finalSubPath = new Path(finalOutputPath, subPath);
            if (!fs.exists(finalSubPath)) {
                fs.mkdirs(finalSubPath);
            }
            int maxSeq = StorageUtil.getMaxFileSequence(fs, finalSubPath, false);
            for (FileStatus eachFile : fs.listStatus(fileStatus.getPath())) {
                if (eachFile.getPath().getName().startsWith("_")) continue;
                this.moveResultFromStageToFinal(fs, stagingResultDir, eachFile, finalOutputPath, nf, ++maxSeq, changeFileSeq);
            }
            return;
        } else {
            String subPath = this.extractSubPath(stagingResultDir, fileStatus.getPath());
            if (subPath == null) return;
            Path finalSubPath = new Path(finalOutputPath, subPath);
            if (changeFileSeq) {
                finalSubPath = new Path(finalSubPath.getParent(), this.replaceFileNameSeq(finalSubPath, fileSeq, nf));
            }
            if (!fs.exists(finalSubPath.getParent())) {
                fs.mkdirs(finalSubPath.getParent());
            }
            if (fs.exists(finalSubPath)) {
                throw new IOException("Already exists data file:" + finalSubPath);
            }
            boolean success = fs.rename(fileStatus.getPath(), finalSubPath);
            if (success) {
                this.LOG.info((Object)("Moving staging file[" + fileStatus.getPath() + "] + " + "to final output[" + finalSubPath + "]"));
                return;
            } else {
                this.LOG.error((Object)("Can't move staging file[" + fileStatus.getPath() + "] + " + "to final output[" + finalSubPath + "]"));
            }
        }
    }

    private String extractSubPath(Path parentPath, Path childPath) {
        String parentPathStr = parentPath.toUri().getPath();
        String childPathStr = childPath.toUri().getPath();
        if (parentPathStr.length() > childPathStr.length()) {
            return null;
        }
        int index = childPathStr.indexOf(parentPathStr);
        if (index != 0) {
            return null;
        }
        return childPathStr.substring(parentPathStr.length() + 1);
    }

    private String replaceFileNameSeq(Path path, int seq, NumberFormat nf) throws IOException {
        String[] tokens = path.getName().split("-");
        if (tokens.length != 4) {
            throw new IOException("Wrong result file name:" + path);
        }
        return tokens[0] + "-" + tokens[1] + "-" + tokens[2] + "-" + nf.format(seq);
    }

    private boolean verifyAllFileMoved(FileSystem fs, Path stagingPath) throws IOException {
        FileStatus[] files = fs.listStatus(stagingPath);
        if (files != null && files.length != 0) {
            for (FileStatus eachFile : files) {
                if (eachFile.isFile()) {
                    this.LOG.error((Object)("There are some unmoved files in staging dir:" + eachFile.getPath()));
                    return false;
                }
                if (!this.verifyAllFileMoved(fs, eachFile.getPath())) {
                    return false;
                }
                fs.delete(eachFile.getPath(), false);
            }
        }
        return true;
    }

    private void visitPartitionedDirectory(FileSystem fs, Path stagingPath, Path outputPath, String stagingParentPathString, Map<Path, Path> renameDirs, Path oldTableDir) throws IOException {
        FileStatus[] files;
        for (FileStatus eachFile : files = fs.listStatus(stagingPath)) {
            if (!eachFile.isDirectory()) continue;
            Path oldPath = eachFile.getPath();
            String recoverPathString = oldPath.toString().replaceAll(stagingParentPathString, oldTableDir.toString());
            Path recoveryPath = new Path(recoverPathString);
            if (!fs.exists(recoveryPath)) {
                fs.mkdirs(recoveryPath);
            }
            this.visitPartitionedDirectory(fs, eachFile.getPath(), outputPath, stagingParentPathString, renameDirs, oldTableDir);
            String newPathString = oldPath.toString().replaceAll(stagingParentPathString, outputPath.toString());
            Path newPath = new Path(newPathString);
            if (!this.isLeafDirectory(fs, eachFile.getPath())) {
                renameDirs.put(eachFile.getPath(), newPath);
                continue;
            }
            if (fs.exists(newPath)) continue;
            fs.mkdirs(newPath);
        }
    }

    private boolean isLeafDirectory(FileSystem fs, Path path) throws IOException {
        FileStatus[] files;
        boolean retValue = false;
        for (FileStatus file : files = fs.listStatus(path)) {
            if (!fs.isDirectory(file.getPath())) continue;
            retValue = true;
            break;
        }
        return retValue;
    }
}

