/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import java.nio.ByteBuffer;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.exception.UnknownDataTypeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.tuple.offheap.RowWriter;
import org.apache.tajo.util.BitArray;

public class RowStoreUtil {
    public static int[] getTargetIds(Schema inSchema, Schema outSchema) {
        int[] targetIds = new int[outSchema.size()];
        int i = 0;
        for (Column target : outSchema.getColumns()) {
            targetIds[i] = inSchema.getColumnId(target.getQualifiedName());
            ++i;
        }
        return targetIds;
    }

    public static Tuple project(Tuple in, Tuple out, int[] targetIds) {
        out.clear();
        for (int idx = 0; idx < targetIds.length; ++idx) {
            out.put(idx, in.get(targetIds[idx]));
        }
        return out;
    }

    public static RowStoreEncoder createEncoder(Schema schema) {
        return new RowStoreEncoder(schema);
    }

    public static RowStoreDecoder createDecoder(Schema schema) {
        return new RowStoreDecoder(schema);
    }

    public static void convert(Tuple tuple, RowWriter writer) {
        writer.startRow();
        block12: for (int i = 0; i < writer.dataTypes().length; ++i) {
            if (tuple.isNull(i)) {
                writer.skipField();
                continue;
            }
            switch (writer.dataTypes()[i].getType()) {
                case BOOLEAN: {
                    writer.putBool(tuple.getBool(i));
                    continue block12;
                }
                case INT2: 
                case INT1: {
                    writer.putInt2(tuple.getInt2(i));
                    continue block12;
                }
                case INT4: 
                case DATE: 
                case INET4: {
                    writer.putInt4(tuple.getInt4(i));
                    continue block12;
                }
                case INT8: 
                case TIME: 
                case TIMESTAMP: {
                    writer.putInt8(tuple.getInt8(i));
                    continue block12;
                }
                case FLOAT4: {
                    writer.putFloat4(tuple.getFloat4(i));
                    continue block12;
                }
                case FLOAT8: {
                    writer.putFloat8(tuple.getFloat8(i));
                    continue block12;
                }
                case TEXT: {
                    writer.putText(tuple.getBytes(i));
                    continue block12;
                }
                case INTERVAL: {
                    writer.putInterval((IntervalDatum)tuple.getInterval(i));
                    continue block12;
                }
                case PROTOBUF: {
                    writer.putProtoDatum((ProtobufDatum)tuple.getProtobufDatum(i));
                    continue block12;
                }
                case NULL_TYPE: {
                    writer.skipField();
                    continue block12;
                }
                default: {
                    throw new UnsupportedException("Unknown data type: " + writer.dataTypes()[i]);
                }
            }
        }
        writer.endRow();
    }

    public static class RowStoreEncoder {
        private Schema schema;
        private BitArray nullFlags;
        private int headerSize;

        private RowStoreEncoder(Schema schema) {
            this.schema = schema;
            this.nullFlags = new BitArray(schema.size());
            this.headerSize = this.nullFlags.bytesLength();
        }

        public byte[] toBytes(Tuple tuple) {
            this.nullFlags.clear();
            int size = this.estimateTupleDataSize(tuple);
            ByteBuffer bb = ByteBuffer.allocate(size + this.headerSize);
            bb.position(this.headerSize);
            block18: for (int i = 0; i < this.schema.size(); ++i) {
                if (tuple.isNull(i)) {
                    this.nullFlags.set(i);
                    continue;
                }
                Column col = this.schema.getColumn(i);
                switch (col.getDataType().getType()) {
                    case NULL_TYPE: {
                        this.nullFlags.set(i);
                        continue block18;
                    }
                    case BOOLEAN: {
                        bb.put(tuple.get(i).asByte());
                        continue block18;
                    }
                    case BIT: {
                        bb.put(tuple.get(i).asByte());
                        continue block18;
                    }
                    case CHAR: {
                        bb.put(tuple.get(i).asByte());
                        continue block18;
                    }
                    case INT2: {
                        bb.putShort(tuple.get(i).asInt2());
                        continue block18;
                    }
                    case INT4: {
                        bb.putInt(tuple.get(i).asInt4());
                        continue block18;
                    }
                    case INT8: {
                        bb.putLong(tuple.get(i).asInt8());
                        continue block18;
                    }
                    case FLOAT4: {
                        bb.putFloat(tuple.get(i).asFloat4());
                        continue block18;
                    }
                    case FLOAT8: {
                        bb.putDouble(tuple.get(i).asFloat8());
                        continue block18;
                    }
                    case TEXT: {
                        byte[] _string = tuple.get(i).asByteArray();
                        bb.putInt(_string.length);
                        bb.put(_string);
                        continue block18;
                    }
                    case DATE: {
                        bb.putInt(tuple.get(i).asInt4());
                        continue block18;
                    }
                    case TIME: 
                    case TIMESTAMP: {
                        bb.putLong(tuple.get(i).asInt8());
                        continue block18;
                    }
                    case INTERVAL: {
                        IntervalDatum interval = (IntervalDatum)tuple.get(i);
                        bb.putInt(interval.getMonths());
                        bb.putLong(interval.getMilliSeconds());
                        continue block18;
                    }
                    case BLOB: {
                        byte[] bytes = tuple.get(i).asByteArray();
                        bb.putInt(bytes.length);
                        bb.put(bytes);
                        continue block18;
                    }
                    case INET4: {
                        byte[] ipBytes = tuple.get(i).asByteArray();
                        bb.put(ipBytes);
                        continue block18;
                    }
                    case INET6: {
                        bb.put(tuple.get(i).asByteArray());
                        continue block18;
                    }
                    default: {
                        throw new RuntimeException((Throwable)new UnknownDataTypeException(col.getDataType().getType().name()));
                    }
                }
            }
            byte[] flags = this.nullFlags.toArray();
            int finalPosition = bb.position();
            bb.position(0);
            bb.put(flags);
            bb.position(finalPosition);
            bb.flip();
            byte[] buf = new byte[bb.limit()];
            bb.get(buf);
            return buf;
        }

        private int estimateTupleDataSize(Tuple tuple) {
            int size = 0;
            block9: for (int i = 0; i < this.schema.size(); ++i) {
                if (tuple.isNull(i)) continue;
                Column col = this.schema.getColumn(i);
                switch (col.getDataType().getType()) {
                    case BOOLEAN: 
                    case BIT: 
                    case CHAR: {
                        ++size;
                        continue block9;
                    }
                    case INT2: {
                        size += 2;
                        continue block9;
                    }
                    case INT4: 
                    case DATE: 
                    case FLOAT4: {
                        size += 4;
                        continue block9;
                    }
                    case INT8: 
                    case TIME: 
                    case TIMESTAMP: 
                    case FLOAT8: {
                        size += 8;
                        continue block9;
                    }
                    case INTERVAL: {
                        size += 12;
                        continue block9;
                    }
                    case TEXT: 
                    case BLOB: {
                        size += 4 + tuple.get(i).asByteArray().length;
                        continue block9;
                    }
                    case INET4: 
                    case INET6: {
                        size += tuple.get(i).asByteArray().length;
                        continue block9;
                    }
                    default: {
                        throw new RuntimeException((Throwable)new UnknownDataTypeException(col.getDataType().getType().name()));
                    }
                }
            }
            return size += 100;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }

    public static class RowStoreDecoder {
        private Schema schema;
        private BitArray nullFlags;
        private int headerSize;

        private RowStoreDecoder(Schema schema) {
            this.schema = schema;
            this.nullFlags = new BitArray(schema.size());
            this.headerSize = this.nullFlags.bytesLength();
        }

        public Tuple toTuple(byte[] bytes) {
            this.nullFlags.clear();
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            VTuple tuple = new VTuple(this.schema.size());
            bb.limit(this.headerSize);
            this.nullFlags.fromByteBuffer(bb);
            bb.limit(bytes.length);
            block15: for (int i = 0; i < this.schema.size(); ++i) {
                if (this.nullFlags.get(i)) {
                    tuple.put(i, (Datum)DatumFactory.createNullDatum());
                    continue;
                }
                Column col = this.schema.getColumn(i);
                TajoDataTypes.DataType type = col.getDataType();
                switch (type.getType()) {
                    case BOOLEAN: {
                        tuple.put(i, DatumFactory.createBool((byte)bb.get()));
                        continue block15;
                    }
                    case BIT: {
                        byte b = bb.get();
                        tuple.put(i, (Datum)DatumFactory.createBit((byte)b));
                        continue block15;
                    }
                    case CHAR: {
                        byte c = bb.get();
                        tuple.put(i, (Datum)DatumFactory.createChar((byte)c));
                        continue block15;
                    }
                    case INT2: {
                        short s = bb.getShort();
                        tuple.put(i, (Datum)DatumFactory.createInt2((short)s));
                        continue block15;
                    }
                    case INT4: 
                    case DATE: {
                        int i_ = bb.getInt();
                        tuple.put(i, DatumFactory.createFromInt4((TajoDataTypes.DataType)type, (int)i_));
                        continue block15;
                    }
                    case INT8: 
                    case TIME: 
                    case TIMESTAMP: {
                        long l = bb.getLong();
                        tuple.put(i, DatumFactory.createFromInt8((TajoDataTypes.DataType)type, (long)l));
                        continue block15;
                    }
                    case INTERVAL: {
                        int month = bb.getInt();
                        long milliseconds = bb.getLong();
                        tuple.put(i, (Datum)new IntervalDatum(month, milliseconds));
                        continue block15;
                    }
                    case FLOAT4: {
                        float f = bb.getFloat();
                        tuple.put(i, (Datum)DatumFactory.createFloat4((float)f));
                        continue block15;
                    }
                    case FLOAT8: {
                        double d = bb.getDouble();
                        tuple.put(i, (Datum)DatumFactory.createFloat8((double)d));
                        continue block15;
                    }
                    case TEXT: {
                        byte[] _string = new byte[bb.getInt()];
                        bb.get(_string);
                        tuple.put(i, (Datum)DatumFactory.createText((byte[])_string));
                        continue block15;
                    }
                    case BLOB: {
                        byte[] _bytes = new byte[bb.getInt()];
                        bb.get(_bytes);
                        tuple.put(i, (Datum)DatumFactory.createBlob((byte[])_bytes));
                        continue block15;
                    }
                    case INET4: {
                        byte[] _ipv4 = new byte[4];
                        bb.get(_ipv4);
                        tuple.put(i, (Datum)DatumFactory.createInet4((byte[])_ipv4));
                        continue block15;
                    }
                    case INET6: {
                        throw new UnsupportedException(type.getType().name());
                    }
                    default: {
                        throw new RuntimeException((Throwable)new UnknownDataTypeException(type.getType().name()));
                    }
                }
            }
            return tuple;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }
}

